/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.subr;

import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispComplex;
import net.morilib.lisp.lite.LispDouble;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.subr.UnaryArgs;

public class Angle
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispComplex) {
            LispComplex n = (LispComplex)c1a;
            if (n.isNaN()) {
                return LispDouble.NaN;
            }
            if (n.isReal()) {
                double r = n.getRealDouble();
                if (r >= 0.0) {
                    return LispDouble.ZERO;
                }
                return new LispDouble(Math.PI);
            }
            return n.angle();
        }
        throw mesg.getError("err.require.complex", c1a);
    }
}

