/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Datum2;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.condition.LispCondition;
import net.morilib.lisp.lite.condition.LispConditionType;
import net.morilib.lisp.lite.condition.LispSimpleCondition;

public class LispCompoundCondition
extends Datum2
implements LispCondition {
    private List<LispSimpleCondition> conditions = new ArrayList<LispSimpleCondition>();

    public LispCompoundCondition(Collection<LispCondition> cs) {
        for (LispCondition c : cs) {
            this.conditions.addAll(c.getConditions());
        }
    }

    public LispCompoundCondition(LispCondition ... cs) {
        this(Arrays.asList(cs));
    }

    @Override
    public Datum getField(String v) {
        for (LispSimpleCondition c : this.conditions) {
            Datum d = c.getField(v);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    @Override
    public boolean setField(String v, Datum val) {
        for (LispSimpleCondition c : this.conditions) {
            if (!c.setField(v, val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasType(LispConditionType type) {
        for (LispSimpleCondition c : this.conditions) {
            if (!c.hasType(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<LispSimpleCondition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    @Override
    public LispSimpleCondition extractCondition(LispConditionType t) {
        for (LispSimpleCondition c : this.conditions) {
            LispSimpleCondition d = c.extractCondition(t);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public Datum getSlot(Symbol sym) {
        return this.getField(sym.getName());
    }

    public boolean setSlot(Symbol sym, Datum val, LispMessage mesg) {
        return this.setField(sym.getName(), val);
    }

    public boolean isDefined(String v) {
        for (LispSimpleCondition c : this.conditions) {
            if (!c.isDefined(v)) continue;
            return true;
        }
        return false;
    }

    public boolean isMutable(String v) {
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<condition");
        for (LispSimpleCondition c : this.conditions) {
            buf.append(" ").append(c.getConditionType().getId());
        }
        buf.append(">");
    }

    @Override
    public String describeShort() {
        StringBuilder b = new StringBuilder();
        String dlm = "";
        for (LispSimpleCondition c : this.conditions) {
            b.append(dlm);
            b.append(c.getConditionType().getId());
            dlm = ", ";
        }
        return b.toString();
    }
}

