/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.List;
import net.morilib.lisp.lite.ClosureClass;
import net.morilib.lisp.lite.CodeExecutor;
import net.morilib.lisp.lite.CompiledCode;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.IntStack;
import net.morilib.lisp.lite.LispCompiler;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.SymbolName;
import net.morilib.lisp.lite.Syntax;
import net.morilib.lisp.lite.SyntaxUtils;
import net.morilib.lisp.lite.Undef;
import net.morilib.lisp.lite.UserIdentifierSyntax;
import net.morilib.lisp.lite.UserSyntax;

public class SynSetS
extends Syntax {
    private Datum getSetval(Datum bcdr, LispMessage mesg) {
        if (bcdr instanceof Cons) {
            Cons c1 = (Cons)bcdr;
            if (c1.getCdr() != Nil.NIL) {
                throw mesg.getError("err.set.malform");
            }
            return c1.getCar();
        }
        throw mesg.getError("err.set.malform");
    }

    private Datum replaceSetval(Datum bcar, Datum bcdr, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, int ttype) {
        if (bcdr instanceof Cons) {
            Datum d1 = ((Cons)bcdr).getCar();
            Cons r1 = new Cons();
            Cons r2 = new Cons();
            r1.setCar(comp.replaceLocalVals(bcar, env, ienv, false, ttype));
            r1.setCdr(r2);
            r2.setCar(comp.replaceLocalVals(d1, env, ienv, false, ttype));
            return r1;
        }
        throw mesg.getError("err.set.malform");
    }

    private UserSyntax isSetMacro(Datum bcar, Environment env) {
        Datum b;
        if (bcar instanceof Symbol && (b = env.findDatum(bcar)) instanceof UserIdentifierSyntax && ((UserIdentifierSyntax)b).toset != null) {
            return ((UserIdentifierSyntax)b).toset;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (!(body instanceof Cons)) throw mesg.getError("err.set.malform");
        Datum bcar = ((Cons)body).getCar();
        Datum bcdr = ((Cons)body).getCdr();
        UserSyntax uis = this.isSetMacro(bcar, env);
        if (uis != null) {
            Datum b2 = comp.expandSyntax(uis, this.getSetval(bcdr, mesg), env, false);
            comp.compile(b2, env, build, toplevel, callsym, istail, symlist, exec, memento, syncased);
            return;
        } else if (bcar instanceof SymbolName) {
            CompiledCode.Builder mbuild = new CompiledCode.Builder();
            Environment menv = new Environment(env);
            comp.compile(this.getSetval(bcdr, mesg), menv, mbuild, callsym, false, symlist, exec, memento, syncased);
            mbuild.addReturnOp();
            ClosureClass cl = new ClosureClass(Nil.NIL, mbuild.getCodeRef());
            build.addPush(cl);
            build.addBeginList();
            build.addEndList();
            build.addCall();
            build.addSet(bcar);
            build.addPop();
            build.addPush(Undef.UNDEF);
            return;
        } else {
            if (!(bcar instanceof Cons)) throw mesg.getError("err.set.name");
            Cons c1 = (Cons)bcar;
            build.addReferSetter(c1.getCar());
            build.addBeginList();
            SyntaxUtils.compileListApply(c1.getCdr(), env, comp, build, callsym, mesg, symlist, exec, memento, syncased);
            comp.compile(this.getSetval(bcdr, mesg), env, build, callsym, false, symlist, exec, memento, syncased);
            build.addAppendList();
            build.addEndList();
            build.addCall();
            build.addPop();
            build.addPush(Undef.UNDEF);
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            if (bcar instanceof SymbolName) {
                return this.replaceSetval(bcar, bcdr, env, comp, ienv, mesg, ttype);
            }
            if (bcar instanceof Cons) {
                return this.replaceSetval(bcar, bcdr, env, comp, ienv, mesg, ttype);
            }
            throw mesg.getError("err.set.name");
        }
        throw mesg.getError("err.set.malform");
    }
}

