/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.ArrayList;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispCompiler;
import net.morilib.lisp.lite.LispException;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.LispVector;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.SynQuasiquote;
import net.morilib.lisp.lite.SyntaxUtils;

public class SynQuasisyntax
extends SynQuasiquote {
    static final Symbol QUASISYNTAX = Symbol.getSymbol("quasisyntax");
    static final Symbol UNSYNTAX = Symbol.getSymbol("unsyntax");
    static final Symbol UNSYNTAX_SPLICING = Symbol.getSymbol("unsyntax-splicing");

    @Override
    boolean equalsQuasiquote(Datum d) {
        return SyntaxUtils.equalsReserved(QUASISYNTAX, d);
    }

    @Override
    boolean equalsUnquote(Datum d) {
        return SyntaxUtils.equalsReserved(UNSYNTAX, d);
    }

    @Override
    boolean equalsUnquoteSplicing(Datum d) {
        return SyntaxUtils.equalsReserved(UNSYNTAX_SPLICING, d);
    }

    @Override
    LispException error(LispMessage mesg) {
        return mesg.getError("err.quasisyntax.malform");
    }

    private static Datum getCaar(Cons c) {
        if (c.getCar() instanceof Cons) {
            return ((Cons)c.getCar()).getCar();
        }
        return null;
    }

    @Override
    public String toString() {
        return "Syntax:quasiquote";
    }

    private Datum quoteE1(int level, Cons c, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, int ttype) {
        Cons c2 = (Cons)c.getCdr();
        Cons res = new Cons();
        Cons r2 = new Cons();
        res.setCar(c.getCar());
        res.setCdr(r2);
        r2.setCar(this.extract1(level, c2.getCar(), env, comp, ienv, mesg, ttype));
        return res;
    }

    private Datum extract1(int level, Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, int ttype) {
        if (body instanceof Cons) {
            Cons c = (Cons)body;
            if (this.equalsQuasiquote(c.getCar())) {
                return this.quoteE1(level + 1, c, env, comp, ienv, mesg, ttype);
            }
            if (this.equalsUnquote(c.getCar())) {
                if (level > 0) {
                    return this.quoteE1(level - 1, c, env, comp, ienv, mesg, ttype);
                }
                if (c.getCdr() instanceof Cons) {
                    return c;
                }
                throw this.error(mesg);
            }
            if (this.equalsUnquoteSplicing(c.getCar())) {
                if (level > 0) {
                    return this.quoteE1(level - 1, c, env, comp, ienv, mesg, ttype);
                }
                if (c.getCdr() instanceof Cons) {
                    return c;
                }
                throw this.error(mesg);
            }
            ArrayList<Datum> lst = new ArrayList<Datum>();
            while (true) {
                Datum caar = SynQuasisyntax.getCaar(c);
                lst.add(this.extract1(level, c.getCar(), env, comp, ienv, mesg, ttype));
                if (!(c.getCdr() instanceof Cons)) break;
                Cons c2 = (Cons)c.getCdr();
                Datum d2 = c2.getCar();
                if (this.equalsUnquote(d2)) {
                    Datum dz = this.extract1(level, c.getCdr(), env, comp, ienv, mesg, ttype);
                    return LispUtils.listToCons(lst, dz);
                }
                if (this.equalsUnquoteSplicing(d2)) {
                    throw this.error(mesg);
                }
                if (level == 0 && this.equalsUnquoteSplicing(caar)) {
                    c = (Cons)c.getCdr();
                    continue;
                }
                c = (Cons)c.getCdr();
            }
            if (c.getCdr() == Nil.NIL) {
                return LispUtils.listToCons(lst);
            }
            Datum dd = this.extract1(level, c.getCdr(), env, comp, ienv, mesg, ttype);
            return LispUtils.listToCons(lst, dd);
        }
        if (body instanceof LispVector) {
            ArrayList<Datum> lst = new ArrayList<Datum>();
            LispVector v = (LispVector)body;
            int i = 0;
            while (i < v.size()) {
                lst.add(this.extract1(level, v.get(i), env, comp, ienv, mesg, ttype));
                ++i;
            }
            return new LispVector(lst);
        }
        return comp.replaceLocalVals(body, env, ienv, false, ttype);
    }

    private Datum extract1Only(int level, Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, int ttype) {
        if (body instanceof Cons) {
            Cons c = (Cons)body;
            if (this.equalsQuasiquote(c.getCar())) {
                return this.extract1Only(level + 1, c, env, comp, ienv, mesg, ttype);
            }
            if (this.equalsUnquote(c.getCar())) {
                if (level > 0) {
                    return this.extract1Only(level - 1, c, env, comp, ienv, mesg, ttype);
                }
                if (c.getCdr() instanceof Cons) {
                    return comp.replaceLocalValsOnly(c, env, ienv, false, ttype);
                }
                throw this.error(mesg);
            }
            if (this.equalsUnquoteSplicing(c.getCar())) {
                if (level > 0) {
                    return this.quoteE1(level - 1, c, env, comp, ienv, mesg, ttype);
                }
                if (c.getCdr() instanceof Cons) {
                    return comp.replaceLocalValsOnly(c, env, ienv, false, ttype);
                }
                throw this.error(mesg);
            }
            Cons res = new Cons();
            res.setCar(this.extract1Only(level, c.getCar(), env, comp, ienv, mesg, ttype));
            res.setCdr(this.extract1Only(level, c.getCdr(), env, comp, ienv, mesg, ttype));
            return res;
        }
        if (body instanceof LispVector) {
            ArrayList<Datum> lst = new ArrayList<Datum>();
            LispVector v = (LispVector)body;
            int i = 0;
            while (i < v.size()) {
                lst.add(this.extract1Only(level, v.get(i), env, comp, ienv, mesg, ttype));
                ++i;
            }
            return new LispVector(lst);
        }
        return comp.replaceLocalVals(body, env, ienv, false, ttype);
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        if (ttype == 0) {
            Cons r0 = new Cons();
            Cons r1 = new Cons();
            r0.setCar(this);
            r0.setCdr(r1);
            r1.setCar(this.extract1Only(0, body, env, comp, ienv, mesg, ttype));
            return new Wrap(r0);
        }
        if (ttype == 1 || ttype == 2) {
            if (body instanceof Cons) {
                Cons res = new Cons();
                Datum b1 = this.extract1(0, ((Cons)body).getCar(), env, comp, ienv, mesg, ttype);
                res.setCar(b1);
                return res;
            }
            throw this.error(mesg);
        }
        throw new RuntimeException();
    }

    private static class Wrap
    extends Datum
    implements SyntaxUtils.SafeWrap {
        private Datum wrapee;

        private Wrap(Datum w) {
            this.wrapee = w;
        }

        @Override
        public Datum getWrapee() {
            return this.wrapee;
        }
    }
}

