/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.lite.ClosureClass;
import net.morilib.lisp.lite.CodeExecutor;
import net.morilib.lisp.lite.CompiledCode;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.IntStack;
import net.morilib.lisp.lite.LispCompiler;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.Syntax;
import net.morilib.lisp.lite.SyntaxUtils;

public class SynLambda
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        Datum bcdr;
        Cons c;
        if (body instanceof Cons) {
            c = (Cons)body;
            bcdr = c.getCdr();
            if (!SyntaxUtils.isValidSymbolList(c.getCar())) {
                throw mesg.getError("err.parameters", c.getCar());
            }
        } else {
            throw mesg.getError("err.lambda.malform");
        }
        CompiledCode.Builder mbuild = new CompiledCode.Builder();
        Environment menv = new Environment(env);
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(menv);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, new Cons(), true, mesg, new ArrayList<Cons>(), exec, memento, syncased);
        nbuild.addReturnOp();
        ClosureClass cln = new ClosureClass(c.getCar(), nbuild.getCodeRef());
        mbuild.addPush(cln);
        mbuild.addReturnOp();
        ClosureClass clm = new ClosureClass(Nil.NIL, mbuild.getCodeRef());
        build.addPush(clm);
        build.addBeginList();
        build.addEndList();
        build.addCall();
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        if (body instanceof Cons) {
            Cons c = (Cons)body;
            Datum bcdr = c.getCdr();
            Cons res = new Cons();
            Environment nenv = new Environment(ienv);
            res.setCar(SyntaxUtils.addLocalValsAll(nenv, c.getCar(), mesg));
            res.setCdr(SyntaxUtils.replaceLocalValsList(bcdr, env, comp, nenv, mesg, ttype));
            return res;
        }
        throw mesg.getError("err.lambda.malform");
    }
}

