/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.morilib.lisp.lite.ClosureClass;
import net.morilib.lisp.lite.CompiledCode;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispFiles;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Subr;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.Undef;
import net.morilib.lisp.lite.subr.SubrUtils;
import net.morilib.lisp.lite.subr.UnaryArgs;
import net.morilib.util.IOs;

public class SubrWithOutputToFile
extends Subr {
    private static final Subr REDI1 = new Redirect1();
    private static final Subr REDI2 = new Redirect2();
    private static final Subr REDI3 = new Redirect3();

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        throw new RuntimeException();
    }

    @Override
    ClosureClass createClosureClass(Environment env) {
        CompiledCode.Builder build = new CompiledCode.Builder();
        CompiledCode.Builder ibuild = new CompiledCode.Builder();
        CompiledCode.Builder fbuild = new CompiledCode.Builder();
        ibuild.addPush(REDI1);
        ibuild.addBeginList();
        ibuild.addReferSymbol(Symbol.getSymbol("fn"));
        ibuild.addAppendList();
        ibuild.addEndList();
        ibuild.addCall();
        ibuild.addPop();
        fbuild.addPush(REDI2);
        fbuild.addBeginList();
        fbuild.addEndList();
        fbuild.addCall();
        fbuild.addPop();
        build.addInitially(ibuild.getCodeRef());
        build.addFinally(fbuild.getCodeRef());
        build.addReferSymbol(Symbol.getSymbol("thunk"));
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addPush(REDI3);
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addPop();
        build.addReturnOp();
        ClosureClass cl1 = new ClosureClass();
        cl1.setParameterList(LispUtils.list(Symbol.getSymbol("fn"), Symbol.getSymbol("thunk")));
        cl1.setCode(build.getCodeRef());
        return cl1;
    }

    private static class Redirect1
    extends UnaryArgs {
        private Redirect1() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            String s = SubrUtils.getString(c1a, mesg);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(LispFiles.getFile(env, s)));
                IOs.pushOut(ps);
                return Undef.UNDEF;
            }
            catch (FileNotFoundException e) {
                throw mesg.getError("err.filenotfound", s);
            }
            catch (IOException e) {
                throw mesg.getError("err.io", e.getMessage());
            }
        }
    }

    private static class Redirect2
    extends Subr {
        private Redirect2() {
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            IOs.popOut();
            return Undef.UNDEF;
        }
    }

    private static class Redirect3
    extends Subr {
        private Redirect3() {
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            System.out.close();
            return Undef.UNDEF;
        }
    }
}

