/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.Locale;
import net.morilib.lisp.lite.InitLoadException;
import net.morilib.lisp.lite.IntLispUtils;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.ReadFileException;
import net.morilib.lisp.lite.Scheme;
import net.morilib.lisp.lite.Symbol;

public final class SchemeOptions {
    private static final int ALL_LIBS = 0;
    private static final int R5RS = 1;
    private static final int SELECT_LIBS = 3;
    private static final int INIT = 1000;
    private static final int EVAL = 1010;
    private static final int EXEC = 1020;
    private static final int LOCALE = 1030;
    private static final int LIB_SELECT = 1040;
    private static final String REPORT_LOAD_TIME = "--report-load-time";
    private static long loadTime;
    public static final String SCHLUSH_VERSION = "0.4.2";

    private SchemeOptions() {
    }

    static Locale parseLocale(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        String[] ls = s.split("(-|\\.|[_,])");
        switch (ls.length) {
            case 1: {
                return new Locale(ls[0].toLowerCase());
            }
            case 2: {
                return new Locale(ls[0].toLowerCase(), ls[1].toUpperCase());
            }
            case 3: {
                return new Locale(ls[0].toLowerCase(), ls[1].toUpperCase(), ls[2].toUpperCase());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Scheme preparseOption(String[] args) {
        Locale l;
        LinkedHashSet<String> libs;
        int state;
        int scm;
        int opt;
        block28: {
            opt = 0;
            scm = 0;
            state = 1000;
            libs = new LinkedHashSet<String>();
            l = null;
            libs.add("core");
            try {
                l = SchemeOptions.parseLocale(System.getProperty("schluessel.locale"));
                String u = System.getProperty("schluessel.r5rs");
                String t = System.getProperty("schluessel.import");
                if (Boolean.parseBoolean(u)) {
                    scm = 1;
                    break block28;
                }
                if (t != null && !t.equals("")) {
                    String[] a = t.split(",");
                    scm = 3;
                    String[] stringArray = a;
                    int n = a.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String z = stringArray[n2];
                        if (z.equals("all")) {
                            scm = 0;
                        }
                        libs.add(z);
                        ++n2;
                    }
                }
            }
            catch (SecurityException z) {}
        }
        block15: while (opt < args.length) {
            String s = args[opt++];
            switch (state) {
                case 1000: {
                    if (s.equals("-version") || s.equals("--version")) {
                        System.out.print("Schluessel, Version ");
                        System.out.println(SCHLUSH_VERSION);
                        System.exit(0);
                        break;
                    }
                    if (s.equalsIgnoreCase("--r5rs")) {
                        scm = 1;
                        break;
                    }
                    if (s.equals("--locale")) {
                        state = 1030;
                        break;
                    }
                    if (s.equals("--import")) {
                        scm = 3;
                        state = 1040;
                        break;
                    }
                    if (s.equals(REPORT_LOAD_TIME)) {
                        loadTime = System.currentTimeMillis();
                        break;
                    }
                    if (s.equals("--load-procedure-eager")) {
                        IntLispUtils.loadEager = true;
                        break;
                    }
                    if (!s.equals("--")) break;
                    break block15;
                }
                case 1030: {
                    l = SchemeOptions.parseLocale(s);
                    if (l == null) {
                        System.err.print("Invalid locale: ");
                        System.err.println(s);
                        System.exit(2);
                    }
                    state = 1000;
                    break;
                }
                case 1040: {
                    if (s.indexOf(45) == 0) {
                        --opt;
                        state = 1000;
                        break;
                    }
                    if (s.equals("all")) {
                        scm = 0;
                        break;
                    }
                    libs.add(s);
                }
            }
        }
        switch (scm) {
            case 0: {
                return Scheme.newInstance(l);
            }
            case 1: {
                return Scheme.newRnRS(5, l);
            }
            case 3: {
                try {
                    return Scheme.newInstance(libs.toArray(new String[0]), l);
                }
                catch (InitLoadException e) {
                    System.err.println(e.getMessage());
                    System.exit(2);
                    throw new RuntimeException();
                }
            }
        }
        throw new RuntimeException();
    }

    public static int parseOption(String[] args, Scheme eval) {
        boolean end = false;
        int opt = 0;
        int state = 1000;
        try {
            String u = System.getProperty("schluessel.foldcase");
            Symbol.foldCase = Boolean.parseBoolean(u) ? 2 : 0;
        }
        catch (SecurityException securityException) {}
        try {
            while (opt < args.length) {
                String s = args[opt++];
                switch (state) {
                    case 1000: {
                        if (s.equals("-e") || s.equals("--eval")) {
                            state = 1010;
                            break;
                        }
                        if (s.equals("-E") || s.equals("--exec")) {
                            state = 1020;
                            break;
                        }
                        if (s.equals("--fold-case")) {
                            Symbol.foldCase = 2;
                            break;
                        }
                        if (s.equals("--no-fold-case")) {
                            Symbol.foldCase = 0;
                            break;
                        }
                        if (s.equals("--")) {
                            if (end) {
                                System.exit(0);
                            }
                            return opt;
                        }
                        if (s.equals("-")) {
                            if (end) {
                                System.exit(0);
                            }
                            return opt - 1;
                        }
                        if (s.equalsIgnoreCase("--r5rs")) break;
                        if (s.equals("--locale")) {
                            state = 1030;
                            break;
                        }
                        if (s.equals("--import")) {
                            state = 1040;
                            break;
                        }
                        if (s.equals(REPORT_LOAD_TIME)) {
                            long endtime = System.currentTimeMillis();
                            System.err.print("Load time: ");
                            System.err.print((double)(endtime - loadTime) / 1000.0);
                            System.err.println(" seconds");
                            break;
                        }
                        if (s.equals("--load-procedure-eager")) break;
                        System.err.print("Invalid option: ");
                        System.err.println(s);
                        System.exit(2);
                        break;
                    }
                    case 1010: {
                        eval.readFile(new StringReader(s));
                        end = true;
                        state = 1000;
                        break;
                    }
                    case 1020: {
                        System.out.println(LispUtils.print(eval.exec(s)));
                        end = true;
                        state = 1000;
                        break;
                    }
                }
            }
        }
        catch (ReadFileException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        if (end) {
            System.exit(0);
        }
        return opt;
    }
}

