/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.ConsListBuilder;
import net.morilib.lisp.lite.ConsOrNil;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Procedure;
import net.morilib.lisp.lite.Scheme;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.subr.IsEqual;
import net.morilib.util.Iterators;

public final class Nil
extends Datum
implements ConsOrNil,
Serializable {
    public static final Nil NIL = new Nil();

    private Nil() {
    }

    @Override
    public String toString() {
        return "()";
    }

    @Override
    public boolean isNil() {
        return true;
    }

    public Object toObject() {
        return null;
    }

    public Datum get(int index) {
        throw new IndexOutOfBoundsException();
    }

    public Datum copySet(int index, Datum d) {
        throw new IndexOutOfBoundsException();
    }

    public Datum set(int index, Datum d) {
        throw new IndexOutOfBoundsException();
    }

    public Datum copy(int b, int e) {
        if (b == e) {
            return NIL;
        }
        throw new IndexOutOfBoundsException();
    }

    public Procedure equivalence() {
        return new IsEqual();
    }

    public Datum copyAdd(Datum d) {
        return new Cons(d, NIL);
    }

    public Datum add(Datum d) {
        return this.copyAdd(d);
    }

    public Datum copyDelete(Datum d) {
        return NIL;
    }

    public Datum delete(Datum d) {
        return NIL;
    }

    public Datum copyDeleteAll(Datum d) {
        return NIL;
    }

    public Datum deleteAll(Datum d) {
        return NIL;
    }

    public Symbol getCollectionName() {
        return Symbol.getSymbol("list");
    }

    public int size() {
        return 0;
    }

    public boolean equivalence(Datum a, Datum b) {
        return a.equals(b);
    }

    public Datum prototype() {
        return NIL;
    }

    public Datum clear() {
        return NIL;
    }

    public Datum duplicate() {
        return NIL;
    }

    public boolean contains(Datum d) {
        return false;
    }

    public Iterator<Datum> iterator() {
        return Iterators.emptyIterator();
    }

    public Datum first() {
        throw new NoSuchElementException();
    }

    public Datum last() {
        throw new NoSuchElementException();
    }

    public Datum insertFirst(Datum d) {
        return new Cons(d, NIL);
    }

    public Datum insertLast(Datum d) {
        return new Cons(d, NIL);
    }

    public Datum copyInsertFirst(Datum d) {
        return new Cons(d, NIL);
    }

    public Datum copyInsertLast(Datum d) {
        return new Cons(d, NIL);
    }

    public Datum[] removeFirst() {
        throw new NoSuchElementException();
    }

    public Datum[] removeLast() {
        throw new NoSuchElementException();
    }

    public Datum[] copyWithoutFirst() {
        throw new NoSuchElementException();
    }

    public Datum[] copyWithoutLast() {
        throw new NoSuchElementException();
    }

    public Datum copyInsert(int index, Datum d) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new Cons(d, NIL);
    }

    public Datum insert(int index, Datum d) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new Cons(d, NIL);
    }

    public Datum copyDelete(int index) {
        throw new IndexOutOfBoundsException();
    }

    public Datum delete(int index) {
        throw new IndexOutOfBoundsException();
    }

    public Iterator<Map.Entry<Datum, Datum>> entryIterator() {
        return Iterators.emptyIterator();
    }

    public Procedure keyEquivalence() {
        return new IsEqual();
    }

    public Procedure valueEquivalence() {
        return new IsEqual();
    }

    public boolean containsKey(Datum k) {
        return false;
    }

    public Datum get(Datum k) {
        return null;
    }

    public Datum[] copyPut(Datum k, Datum v) {
        Datum[] r = new Datum[]{new Cons(new Cons(k, v), NIL), null};
        return r;
    }

    public Datum[] put(Datum k, Datum v) {
        return this.copyPut(k, v);
    }

    public Datum copyDeleteKey(Datum k) {
        return NIL;
    }

    public Datum deleteKey(Datum k) {
        return NIL;
    }

    public int count(Datum c2a) {
        return 0;
    }

    public boolean equivalenceKey(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    public boolean equivalenceValue(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    public Datum copyUpdateAll(Datum k, Procedure f, Procedure th, Environment env, LispMessage mesg) {
        Cons d = th == null ? new Cons(k, LispBoolean.FALSE) : new Cons(k, Scheme.callva(th, env, mesg, new Datum[0]));
        return LispUtils.list(d);
    }

    public Datum updateAll(Datum k, Procedure f, Procedure th, Environment env, LispMessage mesg) {
        return this.copyUpdateAll(k, f, th, env, mesg);
    }

    public Datum copyDeleteAllKey(Datum k) {
        return NIL;
    }

    public Datum deleteAllKey(Datum k) {
        return NIL;
    }

    public Datum copyReplaceAll(Datum k, Datum[] array) {
        ConsListBuilder b = new ConsListBuilder();
        Datum[] datumArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Datum x = datumArray[n2];
            b.append(new Cons(k, x));
            ++n2;
        }
        return b.get();
    }

    public Datum replaceAll(Datum k, Datum[] array) {
        return this.copyReplaceAll(k, array);
    }

    public Datum toList() {
        return this;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("()");
    }

    public int countValue(Datum d) {
        return 0;
    }

    public int countKey(Datum d) {
        return 0;
    }

    @Override
    public Datum getCar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datum getCdr() {
        throw new UnsupportedOperationException();
    }

    public boolean isSorted(Comparator<Datum> cmp) {
        return true;
    }

    public ConsOrNil merge(ConsOrNil m, Comparator<Datum> cmp) {
        return m;
    }

    public ConsOrNil mergeS(ConsOrNil m, Comparator<Datum> cmp) {
        return m;
    }

    public ConsOrNil sort(Comparator<Datum> cmp) {
        return this;
    }

    public void sortS(Comparator<Datum> cmp) {
    }

    public boolean isTerminated() {
        return true;
    }

    public Datum getCurrentDatum() {
        throw new NoSuchElementException();
    }
}

