/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import net.morilib.lang.number.Rational;
import net.morilib.lisp.lite.LispComplex;
import net.morilib.lisp.lite.LispDouble;
import net.morilib.lisp.lite.LispExactReal;
import net.morilib.lisp.lite.LispInteger;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.LispRational;

public abstract class LispReal
extends LispComplex
implements Comparable<LispReal> {
    public static LispReal rationalize(LispReal r1, LispReal r2) {
        if (r1.isNaN() || r2.isNaN()) {
            return LispDouble.NaN;
        }
        if (r1.isInfinity()) {
            return r2.isInfinity() ? LispDouble.NaN : r1;
        }
        if (r2.isInfinity()) {
            return r1.isInfinity() ? LispDouble.NaN : LispDouble.ZERO;
        }
        LispExactReal res = LispRational.valueOf(Rational.rationalize(r1.toExact().toRational(), r2.toExact().toRational()));
        if (r1.isExact() && r2.isExact()) {
            return res;
        }
        return res.toInexact();
    }

    @Override
    public LispReal getReal() {
        return this;
    }

    @Override
    public double getImagDouble() {
        return 0.0;
    }

    @Override
    public LispReal getImag() {
        if (this.isNaN()) {
            return LispDouble.NaN;
        }
        if (this.isExact()) {
            return LispInteger.ZERO;
        }
        return LispDouble.ZERO;
    }

    @Override
    public int compareTo(LispReal o) {
        return this.isLessThan(o) ? -1 : (this.isMoreThan(o) ? 1 : 0);
    }

    public abstract boolean isLessThan(LispReal var1);

    public abstract boolean isMoreThan(LispReal var1);

    public abstract int signum();

    @Override
    public abstract LispExactReal toExact();

    @Override
    public abstract LispReal toInexact();

    public abstract boolean isInfinity();

    public LispReal abs() {
        return this.signum() >= 0 ? this : this.negate();
    }

    public LispReal negate() {
        return this.uminus();
    }

    public LispReal divide(LispReal x) {
        return (LispReal)this.div(x);
    }

    public LispReal multiply(LispReal x) {
        return (LispReal)this.mul(x);
    }

    public LispReal subtract(LispReal x) {
        return (LispReal)this.sub(x);
    }

    public LispReal add(LispReal x) {
        return (LispReal)this.add((LispNumber)x);
    }

    @Override
    public abstract boolean isNaN();

    @Override
    public abstract boolean isOne();

    @Override
    public abstract LispReal uminus();

    @Override
    public abstract String getResult();

    @Override
    public LispReal norm() {
        return this.signum() < 0 ? this.uminus() : this;
    }

    @Override
    public LispReal conjugate() {
        return this;
    }

    public abstract LispReal floor();

    public abstract LispReal ceil();

    public abstract LispReal remainder(LispReal var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

