/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.LispException;
import net.morilib.lisp.lite.LispString;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.ReadException;
import net.morilib.lisp.lite.condition.LispCompoundCondition;
import net.morilib.lisp.lite.condition.LispCondition;
import net.morilib.lisp.lite.condition.LispSimpleCondition;
import net.morilib.util.Maps;

public final class LispMessage {
    private static final String CLSNAME = "net/morilib/lisp/lite/init/messages";
    private static Map<Locale, LispMessage> instances = new HashMap<Locale, LispMessage>();
    private static List<String> pluggedName = new ArrayList<String>();
    private static List<ClassLoader> pluggedLoader = new ArrayList<ClassLoader>();
    public static LispMessage ROOT_MESSAGE = LispMessage.getInstance(Locale.US);
    private ResourceBundle messages;
    private List<ResourceBundle> pluggable = new ArrayList<ResourceBundle>();
    private Locale locale;

    private LispMessage(Locale lc) {
        this.messages = ResourceBundle.getBundle(CLSNAME, lc);
        this.locale = lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static LispMessage getInstance(Locale locale) {
        Locale lc = locale == null ? Locale.getDefault() : locale;
        LispMessage res = instances.get(lc);
        if (res == null) {
            Class<LispMessage> clazz = LispMessage.class;
            // MONITORENTER : net.morilib.lisp.lite.LispMessage.class
            res = new LispMessage(lc);
            instances.put(lc, res);
            // MONITOREXIT : clazz
        }
        res.loadplugin();
        return res;
    }

    public static LispMessage getInstance() {
        return LispMessage.getInstance(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPlugin(String name, ClassLoader loader) {
        List<String> list = pluggedName;
        synchronized (list) {
            pluggedName.add(name);
            pluggedLoader.add(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadplugin() {
        if (this.pluggable.size() < pluggedName.size()) {
            List<String> list = pluggedName;
            synchronized (list) {
                int i = this.pluggable.size();
                while (i < pluggedName.size()) {
                    this.pluggable.add(ResourceBundle.getBundle(pluggedName.get(i), this.messages.getLocale(), pluggedLoader.get(i)));
                    ++i;
                }
            }
        }
    }

    private String get(ResourceBundle rb, String prop) {
        try {
            return this.messages.getString(prop);
        }
        catch (MissingResourceException e) {
            return LispMessage.ROOT_MESSAGE.messages.getString(prop);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String get(String prop) {
        this.loadplugin();
        try {
            return this.get(this.messages, prop);
        }
        catch (MissingResourceException e) {
            ** for (rb : this.pluggable)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return this.get(rb, prop);
            }
            catch (MissingResourceException var5_5) {
                // empty catch block
            }
            continue;
        }
lbl11:
        // 1 sources

        return String.valueOf(this.messages.getString("err.unknown")) + "(" + e.getKey() + ")";
    }

    public String get(String prop, String msg2) {
        return String.valueOf(this.get(prop)) + ":" + msg2;
    }

    public String get(String prop, Datum d) {
        return String.valueOf(this.get(prop)) + ":" + LispUtils.getResult(d);
    }

    public static LispCondition getConditionByKey(String prop) {
        LispSimpleCondition err = Maps.matchPropertyKey("err.require.**", prop) != null ? LispSimpleCondition.newInstance("&assertion") : (Maps.matchPropertyKey("err.*.require.**", prop) != null ? LispSimpleCondition.newInstance("&assertion") : (prop.equals("err.argument") ? LispSimpleCondition.newInstance("&assertion") : (Maps.matchPropertyKey("err.read.**", prop) != null ? LispSimpleCondition.newInstance("&lexical") : (Maps.matchPropertyKey("err.io.**", prop) != null ? LispSimpleCondition.newInstance("&error") : (Maps.matchPropertyKey("err.jdbc.**", prop) != null ? LispSimpleCondition.newInstance("&error") : (prop.equals("err.unbound") ? LispSimpleCondition.newInstance("&undefined") : (prop.equals("err.srfi34.raised") ? LispSimpleCondition.newInstance("&non-continuable") : (prop.equals("err.user") ? LispSimpleCondition.newInstance("&non-continuable") : LispSimpleCondition.newInstance("&violation")))))))));
        return err;
    }

    public LispCondition getCondition(String prop) {
        LispCondition err = LispMessage.getConditionByKey(prop);
        LispSimpleCondition msg = LispSimpleCondition.newInstance("&message");
        msg.setField("message", new LispString(this.get(prop)));
        return new LispCompoundCondition(err, msg);
    }

    public LispException getError(String prop) {
        return new LispException(prop, this.get(prop), this.getCondition(prop));
    }

    public LispException getError(String prop, String msg2) {
        return new LispException(prop, this.get(prop, msg2), this.getCondition(prop));
    }

    public LispException getError(String prop, Datum d) {
        return new LispException(prop, this.get(prop, d), this.getCondition(prop));
    }

    public LispException getError(String prop, int msg2) {
        return new LispException(prop, this.get(prop, Integer.toString(msg2)), this.getCondition(prop));
    }

    public LispException getError(String prop, Throwable th) {
        return new LispException(prop, this.get(prop), this.getCondition(prop), th);
    }

    public LispException getError(String prop, String msg2, Throwable th) {
        return new LispException(prop, this.get(prop, msg2), this.getCondition(prop), th);
    }

    public LispException getError(String prop, Datum d, Throwable th) {
        return new LispException(prop, this.get(prop, d), this.getCondition(prop), th);
    }

    public ReadException getReadError(String prop) {
        return new ReadException(prop, this.get(prop), this.getCondition(prop));
    }

    public ReadException getReadError(String prop, String msg2) {
        return new ReadException(prop, this.get(prop, msg2), this.getCondition(prop));
    }

    public ReadException getReadError(String prop, Datum d) {
        return new ReadException(prop, this.get(prop, d), this.getCondition(prop));
    }

    public LispException getUncaughtException(LispException e) {
        return new LispException("err.srfi18.uncaught", this.get("err.srfi18.uncaught"), this.getCondition("err.srfi18.uncaught"), e);
    }

    public void warn(String prop) {
        System.err.print(this.get("warn.repl.err"));
        System.err.print(" ");
        System.err.println(this.get(prop));
    }

    public Locale getLocale() {
        return this.locale;
    }
}

