/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.morilib.lisp.lite.ConsIterator;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.subr.SubrUtils;

public final class LispFiles {
    static String chdir = null;

    private LispFiles() {
    }

    public static File getFile(Environment env, String s) throws IOException {
        File f = new File(s.replaceFirst("^~/", String.valueOf(System.getProperty("user.home")) + "/"));
        if (f.isAbsolute()) {
            return f;
        }
        if (chdir != null) {
            return new File(chdir, s).getCanonicalFile();
        }
        return new File(System.getProperty("user.dir"), s).getCanonicalFile();
    }

    public static File getFile(Environment env, Datum d, LispMessage mesg) throws IOException {
        return LispFiles.getFile(env, SubrUtils.getString(d, mesg));
    }

    public static File nextFile(ConsIterator itr, Environment env, LispMessage mesg, Datum body) throws IOException {
        return LispFiles.getFile(env, SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body), mesg);
    }

    public static File pwd(Environment env) {
        if (chdir != null) {
            return new File(chdir);
        }
        return new File(System.getProperty("user.dir"));
    }
}

