/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.List;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispException;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.condition.LispCondition;
import net.morilib.lisp.lite.condition.LispConditionType;
import net.morilib.lisp.lite.condition.LispSimpleCondition;
import net.morilib.lisp.lite.subr.BinaryArgs;
import net.morilib.lisp.lite.subr.SubrPredicate;
import net.morilib.lisp.lite.subr.UnaryArgs;

public class ExceptionObject
extends Datum
implements LispCondition {
    private LispException exception;

    ExceptionObject(LispException exception) {
        this.exception = exception;
    }

    public LispException getException() {
        return this.exception;
    }

    @Override
    public Datum getField(String v) {
        return this.exception.getCondition().getField(v);
    }

    @Override
    public boolean setField(String v, Datum val) {
        return this.exception.getCondition().setField(v, val);
    }

    @Override
    public boolean hasType(LispConditionType type) {
        return this.exception.getCondition().hasType(type);
    }

    @Override
    public List<LispSimpleCondition> getConditions() {
        return this.exception.getCondition().getConditions();
    }

    @Override
    public LispSimpleCondition extractCondition(LispConditionType t) {
        return this.exception.getCondition().extractCondition(t);
    }

    @Override
    public String describeShort() {
        return this.exception.getCondition().describeShort();
    }

    public static class IsException
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof ExceptionObject);
        }
    }

    public static class IsExceptionCode
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof ExceptionObject)) {
                throw mesg.getError("err.require.exception", c1a);
            }
            if (!(c2a instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", c2a);
            }
            ExceptionObject e = (ExceptionObject)c1a;
            String s = ((Symbol)c2a).getName();
            return LispBoolean.getInstance(e.exception.getErrorCode().equals(s));
        }
    }

    public static abstract class IsExceptionType
    extends SubrPredicate {
        protected abstract boolean validate(String var1);

        @Override
        protected boolean test(Datum d) {
            if (d instanceof ExceptionObject) {
                return this.validate(((ExceptionObject)d).exception.getErrorCode());
            }
            return false;
        }
    }
}

