/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Nil;
import net.morilib.util.Builder;

public class ConsListBuilder
implements Builder<ConsListBuilder, Datum> {
    private Cons res = null;
    private Cons rp = null;

    public ConsListBuilder() {
    }

    ConsListBuilder(ConsListBuilder src, LispMessage mesg) {
        if (src.res != null) {
            this.appendAll(src.res, mesg);
        }
    }

    public ConsListBuilder appendCons(Cons n) {
        if (this.res == null) {
            this.res = this.rp = n;
        } else {
            this.rp.setCdr(n);
            this.rp = n;
        }
        return this;
    }

    @Override
    public ConsListBuilder append(Datum d) {
        return this.appendCons(new Cons(d, Nil.NIL));
    }

    ConsListBuilder appendAll(Datum n, LispMessage mesg) {
        Datum p = n;
        while (p instanceof Cons) {
            Cons c = (Cons)p;
            this.append(c.getCar());
            p = c.getCdr();
        }
        if (p == Nil.NIL) {
            return this;
        }
        throw mesg.getError("err.list");
    }

    public Datum get() {
        return this.res == null ? Nil.NIL : this.res;
    }

    public Datum get(Datum cdr) {
        if (this.res != null) {
            this.rp.setCdr(cdr);
            return this.res;
        }
        return cdr;
    }

    public String toString() {
        return LispUtils.print(this.get());
    }
}

