/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import net.morilib.lisp.lite.ClosureClass;
import net.morilib.lisp.lite.ClosureClassMethod;
import net.morilib.lisp.lite.CompiledCode;
import net.morilib.lisp.lite.ConsIterator;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Procedure;
import net.morilib.lisp.lite.Settable;

public final class Closure
extends Settable
implements Procedure {
    private Datum params;
    private CompiledCode body;
    private Environment env;

    Closure(ClosureClass cl, Environment env) {
        if (cl == null || env == null) {
            throw new NullPointerException();
        }
        this.params = cl.getParameterList();
        this.body = cl.getCode();
        this.env = env;
    }

    Closure(ClosureClassMethod cl, Environment env) {
        if (cl == null || env == null) {
            throw new NullPointerException();
        }
        this.params = cl.getParameterList();
        this.body = cl.getCode();
        this.env = env;
    }

    Datum getParameterList() {
        return this.params;
    }

    CompiledCode getCode() {
        return this.body;
    }

    Environment getEnvironment() {
        return this.env;
    }

    public int getArity() {
        ConsIterator itr = new ConsIterator(this.params);
        int ary = 0;
        while (itr.hasNext()) {
            itr.next();
            ++ary;
        }
        return itr.getTerminal().isNil() ? ary : -1;
    }

    public Procedure mul(Procedure y) {
        return LispUtils.mul(this, y);
    }

    @Override
    public boolean isTypeProcedure() {
        return true;
    }

    @Override
    public String toString() {
        return "Closure:" + this.printName();
    }

    @Override
    public String display() {
        return "#<closure " + this.printName() + ">";
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<closure " + this.printName() + ">");
    }
}

