/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

public class IncludeInputStream
extends InputStream {
    private Stack<InputStream> readers = new Stack();

    public IncludeInputStream(InputStream reader) {
        this.readers.push(reader);
    }

    @Override
    public void close() throws IOException {
        while (!this.readers.isEmpty()) {
            this.readers.pop().close();
        }
    }

    @Override
    public int read(byte[] cbuf, int off, int len) throws IOException {
        int bt = 0;
        while (!this.readers.isEmpty() && (bt += this.readers.peek().read(cbuf, off + bt, len - bt)) < len) {
            this.readers.pop().close();
        }
        return bt;
    }

    @Override
    public int read() throws IOException {
        int r = -1;
        while (!this.readers.isEmpty() && (r = this.readers.peek().read()) < 0) {
            this.readers.pop().close();
        }
        return r;
    }

    public void include(InputStream rd) {
        this.readers.push(rd);
    }
}

