/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.snmp;

import java.text.SimpleDateFormat;
import net.morilib.net.snmp.ASN1Exception;
import net.morilib.net.snmp.ASN1Tag;

public class ASN1TagGeneralizedTime
extends ASN1Tag {
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyyMMddHHmmssZ");

    ASN1TagGeneralizedTime() {
        super(0, false, (byte)24);
    }

    @Override
    protected Object analyse(byte[] bts) throws ASN1Exception {
        String s = new String(bts);
        try {
            if (s.endsWith("Z")) {
                s = String.valueOf(s.replaceFirst("Z$", "")) + "+0000";
            }
            s = s.replaceFirst("\\.[0-9]+", "");
            return FMT.format(s);
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception();
        }
    }
}

