/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.io.Serializable;
import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousSignedArray;
import net.morilib.lisp.uvector.LispS32Vector;
import net.morilib.util.primitive.LongArrayVector;
import net.morilib.util.uvector.LongArray;

public class LispS64Vector
extends Atom
implements HomogeneousSignedArray,
Serializable {
    private LongArray vector;

    private LispS64Vector() {
    }

    public LispS64Vector(long ... bs) {
        this.vector = LongArray.newArray(bs);
    }

    public static LispS64Vector malloc(int size) {
        LispS64Vector res = new LispS64Vector();
        res.vector = LongArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        if (!(d instanceof LispReal)) {
            return false;
        }
        return ((LispReal)d).inLongRange();
    }

    private static long[] toLongList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        LongArrayVector v = new LongArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispS64Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.s64", d);
            }
            v.add(d.getLong());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toLongArray();
    }

    @Override
    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#s64(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append((int)this.vector.getLong(i));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String getResult() {
        return this.print();
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.print());
    }

    @Override
    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispS64Vector)) {
            return false;
        }
        if (!(d2 instanceof LispS64Vector)) {
            return false;
        }
        return ((LispS64Vector)d1).vector.equals(((LispS64Vector)d2).vector);
    }

    @Override
    public LispInteger get(int index) {
        return LispInteger.valueOf(this.vector.getLong(index));
    }

    @Override
    public void set(int index, LispReal x) {
        this.vector.setLong(index, x.castLong());
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispS64Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.s64", x);
        }
    }

    @Override
    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    @Override
    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    @Override
    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    @Override
    public Datum ref(Datum arg, LispMessage mesg) {
        int k = SubrUtils.getSmallInt(arg, mesg);
        if (k < 0 || k >= this.size()) {
            throw mesg.getError("err.accessor.ref.outofrange", arg);
        }
        return this.get(k);
    }

    public static class EqualS64Vector
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispS64Vector)) {
                throw mesg.getError("err.uvector.require.s64", c1a);
            }
            if (!(c2a instanceof LispS32Vector)) {
                throw mesg.getError("err.uvector.require.s64", c2a);
            }
            return LispBoolean.getInstance(((LispS64Vector)c1a).vector.equals(((LispS64Vector)c2a).vector));
        }
    }

    public static class IsS64Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispS64Vector);
        }
    }

    public static class ListToS64Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispS64Vector(LispS64Vector.toLongList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeS64Vector
    extends Subr {
        private long[] makeVector(int len, long d) {
            LongArrayVector b = new LongArrayVector();
            int i = 0;
            while (i < len) {
                b.add(d);
                ++i;
            }
            return b.toLongArray();
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispS64Vector(this.makeVector(t, 0L));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispS64Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.s64", lst.get(1));
                }
                return new LispS64Vector(this.makeVector(t, lst.get(1).getLong()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class S64Vector
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispS64Vector(LispS64Vector.toLongList(body, mesg));
        }
    }

    public static class S64VectorToList
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispS64Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispS64Vector v = (LispS64Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(LispInteger.valueOf(v.vector.getLong(i)));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.s64", c1a);
        }
    }
}

