/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.topology;

import java.util.HashSet;
import net.morilib.lisp.Datum;
import net.morilib.lisp.collection.LispHashSet;
import net.morilib.lisp.topology.AbstractLispTopology;
import net.morilib.lisp.topology.ILispEnumerableTopology;
import net.morilib.lisp.topology.ILispTopology;

public abstract class AbstractLispFiniteTopology
extends AbstractLispTopology
implements ILispEnumerableTopology {
    @Override
    public boolean isContained(ILispTopology t) {
        if (t.isEmpty()) {
            return false;
        }
        if (t.isUniverse()) {
            return true;
        }
        for (Datum d : this.getJavaSet()) {
            if (t.isNeighborhoodOf(d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIndependent(ILispTopology t) {
        if (t.isEmpty()) {
            return true;
        }
        if (t.isUniverse()) {
            return false;
        }
        for (Datum d : this.getJavaSet()) {
            if (!t.isNeighborhoodOf(d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ILispTopology unionTopology(ILispTopology t) {
        if (t instanceof ILispEnumerableTopology) {
            HashSet<Datum> r = new HashSet<Datum>();
            r.addAll(this.getJavaSet());
            r.addAll(((ILispEnumerableTopology)t).getJavaSet());
            return new LispHashSet(r);
        }
        return super.unionTopology(t);
    }

    @Override
    public ILispTopology intersectionTopology(ILispTopology t) {
        if (t instanceof ILispEnumerableTopology) {
            HashSet<Datum> r = new HashSet<Datum>();
            r.addAll(this.getJavaSet());
            r.retainAll(((ILispEnumerableTopology)t).getJavaSet());
            return new LispHashSet(r);
        }
        return super.intersectionTopology(t);
    }
}

