/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.progress;

import javax.swing.JProgressBar;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.LispSwing;
import net.morilib.lisp.swing.progress.LispProgressBar;
import net.morilib.util.Iterators;

public class MakeProgressBar
extends Subr {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        JProgressBar bar;
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = Iterators.nextIf(itr);
        Datum d2 = Iterators.nextIf(itr);
        Datum d3 = Iterators.nextIf(itr);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (d1 instanceof Symbol) {
            int orient = LispSwing.getOrientation(d1, mesg);
            if (d2 == null && d3 == null) {
                bar = new JProgressBar(orient);
                return new LispProgressBar(bar);
            } else {
                if (d2 == null || d3 == null) throw mesg.getError("err.argument", body);
                int max = SubrUtils.getSmallInt(d2, mesg);
                int min = SubrUtils.getSmallInt(d3, mesg);
                if (min > max) {
                    throw mesg.getError("err.range.invalid");
                }
                bar = new JProgressBar(orient, min, max);
            }
            return new LispProgressBar(bar);
        } else {
            if (d3 != null) {
                throw mesg.getError("err.argument", body);
            }
            if (d1 == null) {
                bar = new JProgressBar();
                return new LispProgressBar(bar);
            } else {
                if (d2 == null) throw mesg.getError("err.argument", body);
                int max = SubrUtils.getSmallInt(d1, mesg);
                int min = SubrUtils.getSmallInt(d2, mesg);
                if (min > max) {
                    throw mesg.getError("err.range.invalid");
                }
                bar = new JProgressBar(min, max);
            }
        }
        return new LispProgressBar(bar);
    }
}

