/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.subr.BinaryArgs;

public class MakePolar
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof LispNumber)) {
            throw mesg.getError("err.require.real", c1a);
        }
        if (!(c2a instanceof LispNumber)) {
            throw mesg.getError("err.require.real", c2a);
        }
        LispNumber n1 = (LispNumber)c1a;
        LispNumber n2 = (LispNumber)c2a;
        if (n1.isNaN() || n2.isNaN()) {
            return LispDouble.NaN;
        }
        if (n1.isReal() && n2.isZero()) {
            return n1;
        }
        if (n1.isReal() && n2.isReal()) {
            LispReal r = n1.getReal();
            LispReal t = n2.getReal();
            if (r.signum() == 0) {
                return r.isExact() && t.isExact() ? LispInteger.ZERO : LispDouble.ZERO;
            }
            if (t.isInfinity()) {
                return LispDouble.NaN;
            }
            return LispComplex.newPolar(r, t);
        }
        if (!n1.isReal()) {
            throw mesg.getError("err.require.real", n1);
        }
        throw mesg.getError("err.require.real", n2);
    }
}

