/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sql;

import java.sql.SQLException;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.sql.LispJdbcPrepared;
import net.morilib.lisp.sql.LispSQLException;
import net.morilib.sql.util.DBMSDependentException;

public class JdbcUpdateS
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() < 1) {
            throw mesg.getError("err.argument", body);
        }
        if (!(l.get(0) instanceof LispJdbcPrepared)) {
            throw mesg.getError("err.jdbc.require.prepared", l.get(0));
        }
        LispJdbcPrepared lps = (LispJdbcPrepared)l.get(0);
        int i = 1;
        while (i < l.size()) {
            try {
                lps.setDatum(i, l.get(i));
            }
            catch (SQLException e) {
                throw LispSQLException.getError(mesg, e);
            }
            catch (DBMSDependentException e) {
                throw mesg.getError("err.jdbc.typemapping", l.get(i));
            }
            ++i;
        }
        try {
            return LispInteger.valueOf(lps.update());
        }
        catch (SQLException e) {
            throw LispSQLException.getError(mesg, e);
        }
    }
}

