/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SyntaxSimple;
import net.morilib.lisp.r6rs.io.transcd.LispErrorHandlingMode;
import net.morilib.lisp.subr.SubrUtils;

public class SynsErrorHandlingMode
extends SyntaxSimple {
    private static final Symbol IGNORE = Symbol.getSymbol("ignore");
    private static final Symbol RAISE = Symbol.getSymbol("raise");
    private static final Symbol REPLACE = Symbol.getSymbol("replace");

    @Override
    public Datum toDatum(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (d.equals(IGNORE)) {
            return LispErrorHandlingMode.IGNORE;
        }
        if (d.equals(RAISE)) {
            return LispErrorHandlingMode.RAISE;
        }
        if (d.equals(REPLACE)) {
            return LispErrorHandlingMode.REPLACE;
        }
        return LispErrorHandlingMode.REPLACE;
    }
}

