/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.r6rs.io.ILispBinaryOutputPort;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.uvector.ILispBytevector;

public class PutBytevector
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (!(d1 instanceof ILispBinaryOutputPort)) {
            throw mesg.getError("err.io.require.port.binary.output", d1);
        }
        if (d2 instanceof ILispBytevector) {
            ILispBytevector b = (ILispBytevector)((Object)d2);
            int st = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int en = SubrUtils.nextSmallInt((Iterator<Datum>)itr, b.size() - st, mesg) + st;
            SubrUtils.checkTerminated(itr, body, mesg);
            if (st < 0 || st >= b.size()) {
                throw mesg.getError("err.range.invalid");
            }
            if (en < 0 || en > b.size()) {
                throw mesg.getError("err.range.invalid");
            }
            if (st > en) {
                throw mesg.getError("err.range.invalid");
            }
            try {
                ((ILispBinaryOutputPort)((Object)d1)).putBytes(b.toBytes(), st, en);
                return Undef.UNDEF;
            }
            catch (IOException e) {
                throw mesg.getError("err.io", e.getMessage());
            }
        }
        throw mesg.getError("err.uvector.require.8", d2);
    }
}

