/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.r6rs.io.ILispBinaryInputPort;
import net.morilib.lisp.r6rs.io.InvalidPositionException;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.util.Bytes;

public class LispByteArrayBinaryInputPort
extends Datum2
implements ILispBinaryInputPort {
    private byte[] buf;
    private int ptr;

    public LispByteArrayBinaryInputPort(byte[] bytes) {
        this.buf = new byte[bytes.length];
        this.ptr = 0;
        System.arraycopy(bytes, 0, this.buf, 0, this.buf.length);
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return null;
    }

    @Override
    public boolean hasPortPosition() {
        return true;
    }

    @Override
    public Datum getPortPosition() {
        return LispInteger.valueOf(this.ptr);
    }

    @Override
    public boolean hasSetPortPosition() {
        return true;
    }

    @Override
    public void setPortPosition(Datum pos) throws InvalidPositionException {
        if (!(pos instanceof LispSmallInt)) {
            throw new InvalidPositionException();
        }
        int p = pos.getInt();
        if (p < 0 || p > this.buf.length) {
            throw new InvalidPositionException();
        }
        this.ptr = p;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isPortEof() {
        return this.ptr >= this.buf.length;
    }

    @Override
    public int getByte() throws IOException {
        return this.ptr < this.buf.length ? Bytes.ubyteToInt(this.buf[this.ptr++]) : -1;
    }

    @Override
    public int lookaheadByte() throws IOException {
        return this.ptr < this.buf.length ? Bytes.ubyteToInt(this.buf[this.ptr]) : -1;
    }

    @Override
    public byte[] getBytes(int n) throws IOException {
        if (this.ptr < this.buf.length) {
            int l = Math.min(n, this.buf.length - this.ptr);
            byte[] r = new byte[l];
            System.arraycopy(this.buf, this.ptr, r, 0, l);
            this.ptr += l;
            return r;
        }
        return null;
    }

    @Override
    public int getBytes(byte[] b, int start, int end) throws IOException {
        if (this.ptr < this.buf.length) {
            int l = Math.min(end - start, this.buf.length - this.ptr);
            System.arraycopy(this.buf, this.ptr, b, start, l);
            this.ptr += l;
            return l;
        }
        return -1;
    }

    @Override
    public byte[] getBytesSome() throws IOException {
        return this.getBytes(72);
    }

    @Override
    public byte[] getBytesAll() throws IOException {
        if (this.ptr < this.buf.length) {
            int l = this.buf.length - this.ptr;
            byte[] r = new byte[l];
            System.arraycopy(this.buf, this.ptr, r, 0, l);
            this.ptr += l;
            return r;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, this.ptr, this.buf.length - this.ptr);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<bytevector-binary-input-stream>");
    }
}

