/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.bytevector;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.r6rs.bytevector.LispBytevector;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.io.IllegalUTFException;
import net.morilib.util.io.UTF8;

public class Utf8ToString
extends Subr {
    private static int _read(InputStream ins) {
        try {
            return UTF8.read(ins);
        }
        catch (IllegalUTFException e) {
            return 65533;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        int ch;
        StringBuilder b = new StringBuilder();
        ConsIterator itr = new ConsIterator(body);
        LispBytevector v = LispBytevector.datumToBytevector(SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body), mesg);
        int f = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
        int t = SubrUtils.nextSmallInt((Iterator<Datum>)itr, v.length(), mesg);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (f < 0 || f > v.length()) {
            throw mesg.getError("err.range.invalid", f);
        }
        if (t < 0 || t > v.length()) {
            throw mesg.getError("err.range.invalid", t);
        }
        if (t < f) {
            throw mesg.getError("err.range.invalid");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(v.vector, f, t - f);
        while ((ch = Utf8ToString._read(bis)) >= 0) {
            b.appendCodePoint(ch);
        }
        return new LispString(b.toString());
    }
}

