/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.bytevector;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.r6rs.bytevector.LispBytevector;
import net.morilib.lisp.r6rs.bytevector.SynEndianness;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Endianness2;
import net.morilib.util.Iterators;
import net.morilib.util.io.IllegalUTFException;
import net.morilib.util.io.UTF16;

public class Utf16ToString
extends Subr {
    private static int _read(InputStream ins, Endianness2 en) {
        try {
            if (en.equals(Endianness2.BIG)) {
                return UTF16.read(ins, true);
            }
            return UTF16.read(ins, false);
        }
        catch (IllegalUTFException e) {
            return 65533;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        int ch;
        ByteArrayInputStream bis;
        Endianness2 e;
        StringBuilder b;
        block7: {
            b = new StringBuilder();
            ConsIterator itr = new ConsIterator(body);
            LispBytevector v = LispBytevector.datumToBytevector(SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body), mesg);
            Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum d3 = Iterators.nextIf(itr);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(d2 instanceof Symbol)) {
                throw mesg.getError("err.r6rs.require.endianness", d2);
            }
            e = SynEndianness.getEndianness(d2, mesg);
            int f = 0;
            int t = v.length();
            if ((t - f) % 2 != 0) {
                throw mesg.getError("err.r6rs.range.mustbemultiple");
            }
            bis = new ByteArrayInputStream(v.vector, f, t - f);
            if (d3 == null || !d3.isTrue()) {
                try {
                    if (UTF16.readBOM(bis)) {
                        e = Endianness2.BIG;
                        break block7;
                    }
                    e = Endianness2.LITTLE;
                }
                catch (IOException e1) {
                    bis.reset();
                }
            }
        }
        while ((ch = Utf16ToString._read(bis, e)) >= 0) {
            b.appendCodePoint(ch);
        }
        return new LispString(b.toString());
    }
}

