/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.bytevector;

import java.io.Serializable;
import java.util.Arrays;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.accessor.ILispRef;
import net.morilib.lisp.subr.SubrUtils;

public class LispBytevector
extends Datum2
implements Cloneable,
ILispRef,
Serializable {
    byte[] vector;

    protected LispBytevector(byte[] vector) {
        this.vector = vector;
    }

    public LispBytevector(int len, byte fill) {
        this.vector = new byte[len];
        Arrays.fill(this.vector, fill);
    }

    public LispBytevector(LispBytevector v) {
        this(Arrays.copyOf(v.vector, v.vector.length));
    }

    static LispBytevector datumToBytevector(Datum d, LispMessage mesg) {
        if (d instanceof LispBytevector) {
            return (LispBytevector)d;
        }
        throw mesg.getError("err.r6rs.require.bytevector", d);
    }

    static byte datumToByteOrOctet(Datum d, LispMessage mesg) {
        if (!(d instanceof LispSmallInt)) {
            throw mesg.getError("err.r6rs.require.byteoroctet", d);
        }
        int fl = ((LispSmallInt)d).getInt();
        if (fl < -128 || fl > 255) {
            throw mesg.getError("err.r6rs.require.byteoroctet", d);
        }
        if (fl > 127) {
            fl -= 256;
        }
        return (byte)fl;
    }

    public int length() {
        return this.vector.length;
    }

    public boolean isEqualTo(LispBytevector v) {
        return Arrays.equals(this.vector, v.vector);
    }

    public void fill(byte b, int start, int end) {
        Arrays.fill(this.vector, start, end, b);
    }

    public void copy(int srcPos, LispBytevector dest, int destPos, int length) {
        System.arraycopy(this.vector, srcPos, dest.vector, destPos, length);
    }

    public LispBytevector duplicate(int start, int end) {
        return new LispBytevector(Arrays.copyOfRange(this.vector, start, end));
    }

    public byte get(int k) {
        return this.vector[k];
    }

    public void set(int k, byte b) {
        this.vector[k] = b;
    }

    public Datum toList() {
        ConsListBuilder d = new ConsListBuilder();
        byte[] byArray = this.vector;
        int n = this.vector.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            d.append(LispInteger.valueOf(b < 0 ? b + 256 : b));
            ++n2;
        }
        return d.get();
    }

    @Override
    public LispBytevector clone() {
        return new LispBytevector(this);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.vector, this.vector.length);
    }

    @Override
    public Datum ref(Datum arg, LispMessage mesg) {
        int k = SubrUtils.getSmallInt(arg, mesg);
        if (k < 0 || k >= this.vector.length) {
            throw mesg.getError("err.accessor.ref.outofrange", arg);
        }
        return LispInteger.valueOf(this.vector[k]);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#vb8(");
        int i = 0;
        while (i < this.vector.length) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.vector[i]);
            ++i;
        }
        buf.append(")");
    }
}

