/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.test;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.stat.StatisticsUtils;
import net.morilib.math.stat.dist.continuous.TDistribution;
import net.morilib.util.primitive.DoubleArrayVector;
import net.morilib.util.primitive.DoubleVector;

public class IsTestT1Sample
extends QuaternaryArgs {
    private void todouble(ConsIterator itr, DoubleVector v, LispMessage mesg) {
        while (itr.hasNext()) {
            v.addDouble(SubrUtils.getDouble(itr.next(), mesg));
        }
    }

    @Override
    protected Datum execute(Datum c1a, Datum c4a, Datum c5a, Datum c6a, Environment env, LispMessage mesg) {
        double max;
        double min;
        double exp = SubrUtils.getDouble(c4a, mesg);
        String type = SubrUtils.getSymbolName(c5a, mesg);
        double sign = SubrUtils.getDouble(c6a, mesg);
        DoubleArrayVector obs = new DoubleArrayVector();
        this.todouble(new ConsIterator(c1a), obs, mesg);
        double[] obsv = obs.toDoubleArray();
        int num = obs.size();
        double mean = StatisticsUtils.mean(obsv);
        double var = StatisticsUtils.variance(obsv);
        double t = (mean - exp) / Math.sqrt(var / (double)num);
        TDistribution tdis = new TDistribution(num - 1);
        if (type.equals(">")) {
            min = Double.NEGATIVE_INFINITY;
            max = -tdis.invCdf(sign);
        } else if (type.equals("<")) {
            min = tdis.invCdf(sign);
            max = Double.POSITIVE_INFINITY;
        } else {
            min = tdis.invCdf(sign / 2.0);
            max = -min;
        }
        return LispBoolean.getInstance(min < t && t < max);
    }
}

