/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.test;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.math.stat.dist.continuous.GammaDistribution;
import net.morilib.util.primitive.DoubleArrayVector;
import net.morilib.util.primitive.DoubleVector;

public class IsTestFitChiSquared
extends TernaryArgs {
    private void todouble(ConsIterator itr, DoubleVector v, LispMessage mesg) {
        while (itr.hasNext()) {
            v.addDouble(SubrUtils.getDouble(itr.next(), mesg));
        }
    }

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        double chi = 0.0;
        int i = 0;
        DoubleArrayVector obs = new DoubleArrayVector();
        DoubleArrayVector exp = new DoubleArrayVector();
        this.todouble(new ConsIterator(c1a), obs, mesg);
        this.todouble(new ConsIterator(c2a), exp, mesg);
        double alf = SubrUtils.getDouble(c3a, mesg);
        while (i < obs.size() && i < exp.size()) {
            double x = obs.getDouble(i) - exp.getDouble(i);
            chi += x * x / exp.getDouble(i);
            ++i;
        }
        GammaDistribution dis = GammaDistribution.chiSquared(i);
        return LispBoolean.getInstance(chi < dis.invCdf(1.0 - alf));
    }
}

