/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.geometry.g2d;

import java.awt.geom.AffineTransform;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.geometry.g2d.ILispAffineTransform2D;
import net.morilib.lisp.math.geometry.g2d.LispDoubleAffineTransform2D;
import net.morilib.lisp.math.matrix.AbstractImmutableLispMatrix;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.LispMatrixException;

public class LispDoubleLinearTransform2D
extends AbstractImmutableLispMatrix
implements ILispAffineTransform2D {
    public static final LispDoubleLinearTransform2D IDENTITY = new LispDoubleLinearTransform2D(1.0, 1.0, 0.0, 0.0);
    public static final LispDoubleLinearTransform2D REFLECTION_X = new LispDoubleLinearTransform2D(1.0, -1.0, 0.0, 0.0);
    public static final LispDoubleLinearTransform2D REFLECTION_Y = new LispDoubleLinearTransform2D(-1.0, 1.0, 0.0, 0.0);
    private double scaleX;
    private double scaleY;
    private double shearX;
    private double shearY;

    public LispDoubleLinearTransform2D(double scaleX, double scaleY, double shearX, double shearY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.shearX = shearX;
        this.shearY = shearY;
    }

    public static LispDoubleLinearTransform2D createRotateByRadian(double rad) {
        return new LispDoubleLinearTransform2D(Math.cos(rad), Math.cos(rad), Math.sin(rad), -Math.sin(rad));
    }

    public static LispDoubleLinearTransform2D createRotateByIntDegree(int deg) {
        switch (deg % 360) {
            case 0: {
                return IDENTITY;
            }
            case -270: 
            case 90: {
                return new LispDoubleLinearTransform2D(0.0, 0.0, 1.0, -1.0);
            }
            case -180: 
            case 180: {
                return new LispDoubleLinearTransform2D(-1.0, -1.0, 0.0, 0.0);
            }
            case -90: 
            case 270: {
                return new LispDoubleLinearTransform2D(0.0, 0.0, -1.0, 1.0);
            }
        }
        return LispDoubleLinearTransform2D.createRotateByRadian((double)deg * Math.PI / 180.0);
    }

    public static LispDoubleLinearTransform2D createScale(double sx, double sy) {
        return new LispDoubleLinearTransform2D(1.0 * sx, 1.0 * sy, 0.0, 0.0);
    }

    public static LispDoubleLinearTransform2D createShear(double sx, double sy) {
        return new LispDoubleLinearTransform2D(1.0, 1.0, sx, sy);
    }

    public static LispDoubleLinearTransform2D createSqueeze(double k) {
        return new LispDoubleLinearTransform2D(k, 1.0 / k, 0.0, 0.0);
    }

    @Override
    public LispNumber get(int row, int column) {
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        return new LispDouble(this.scaleX);
                    }
                    case 1: {
                        return new LispDouble(this.shearX);
                    }
                }
                throw new IndexOutOfBoundsException();
            }
            case 1: {
                switch (column) {
                    case 0: {
                        return new LispDouble(this.shearY);
                    }
                    case 1: {
                        return new LispDouble(this.scaleY);
                    }
                }
                throw new IndexOutOfBoundsException();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int rowSize() {
        return 2;
    }

    @Override
    public int columnSize() {
        return 2;
    }

    @Override
    public LispReal getScaleX() {
        return new LispDouble(this.scaleX);
    }

    @Override
    public LispReal getScaleY() {
        return new LispDouble(this.scaleY);
    }

    @Override
    public LispReal getShearX() {
        return new LispDouble(this.shearX);
    }

    @Override
    public LispReal getShearY() {
        return new LispDouble(this.shearY);
    }

    @Override
    public LispReal getTranslateX() {
        return LispDouble.ZERO;
    }

    @Override
    public LispReal getTranslateY() {
        return LispDouble.ZERO;
    }

    @Override
    public double getScaleXDouble() {
        return this.scaleX;
    }

    @Override
    public double getScaleYDouble() {
        return this.scaleY;
    }

    @Override
    public double getShearXDouble() {
        return this.shearX;
    }

    @Override
    public double getShearYDouble() {
        return this.shearY;
    }

    @Override
    public double getTranslateXDouble() {
        return 0.0;
    }

    @Override
    public double getTranslateYDouble() {
        return 0.0;
    }

    @Override
    public AffineTransform toAWTTransform() {
        return new AffineTransform(this.scaleX, this.shearY, this.shearX, this.scaleY, 0.0, 0.0);
    }

    @Override
    public LispNumber determinant() {
        return new LispDouble(this.scaleX * this.scaleY - this.shearX * this.shearY);
    }

    @Override
    public ILispMatrix mul(ILispMatrix a) {
        if (a instanceof LispDoubleLinearTransform2D) {
            return this.concatenate((ILispAffineTransform2D)a);
        }
        return super.mul(a);
    }

    @Override
    public ILispMatrix transpose() {
        return new LispDoubleLinearTransform2D(this.scaleX, this.scaleY, this.shearY, this.shearX);
    }

    @Override
    public ILispMatrix adjoint() {
        return this;
    }

    @Override
    public ILispMatrix add(ILispMatrix a) {
        if (a instanceof LispDoubleLinearTransform2D) {
            LispDoubleLinearTransform2D z = (LispDoubleLinearTransform2D)a;
            return new LispDoubleLinearTransform2D(this.scaleX + z.scaleX, this.scaleY + z.scaleY, this.shearX + z.shearX, this.shearY + z.shearY);
        }
        return super.add(a);
    }

    @Override
    public ILispMatrix sub(ILispMatrix a) {
        if (a instanceof LispDoubleLinearTransform2D) {
            LispDoubleLinearTransform2D z = (LispDoubleLinearTransform2D)a;
            return new LispDoubleLinearTransform2D(this.scaleX - z.scaleX, this.scaleY - z.scaleY, this.shearX - z.shearX, this.shearY - z.shearY);
        }
        return super.sub(a);
    }

    @Override
    public ILispMatrix mul(LispNumber a) {
        if (a.isReal()) {
            return new LispDoubleLinearTransform2D(this.scaleX * a.getRealDouble(), this.scaleY * a.getRealDouble(), this.shearX * a.getRealDouble(), this.shearY * a.getRealDouble());
        }
        return super.mul(a);
    }

    @Override
    public ILispMatrix uminus() {
        return new LispDoubleLinearTransform2D(-this.scaleX, -this.scaleY, -this.shearX, -this.shearY);
    }

    @Override
    public ILispMatrix inv() {
        double D = this.scaleX * this.scaleY - this.shearX * this.shearY;
        if (D == 0.0) {
            throw new LispMatrixException();
        }
        return new LispDoubleLinearTransform2D(this.scaleY / D, this.scaleX / D, -this.shearX / D, -this.shearY / D);
    }

    @Override
    public ILispAffineTransform2D rotateByRadian(double rad) {
        return new LispDoubleLinearTransform2D(this.scaleX * Math.cos(rad) + this.shearX * -Math.sin(rad), this.shearY * Math.sin(rad) + this.scaleY * Math.cos(rad), this.scaleX * Math.sin(rad) + this.shearX * Math.cos(rad), this.shearY * Math.cos(rad) + this.scaleY * -Math.sin(rad));
    }

    @Override
    public ILispAffineTransform2D rotateByIntDegree(int deg) {
        switch (deg % 360) {
            case 0: {
                return this;
            }
            case -270: 
            case 90: {
                return new LispDoubleLinearTransform2D(-this.shearX, this.shearY, this.scaleX, -this.scaleY);
            }
            case -180: 
            case 180: {
                return new LispDoubleLinearTransform2D(-this.scaleX, -this.scaleY, -this.shearX, -this.shearY);
            }
            case -90: 
            case 270: {
                return new LispDoubleLinearTransform2D(this.shearX, -this.shearY, -this.scaleX, this.scaleY);
            }
        }
        return this.rotateByRadian((double)deg * Math.PI / 180.0);
    }

    @Override
    public ILispAffineTransform2D scale(double sx, double sy) {
        return new LispDoubleLinearTransform2D(this.scaleX * sx, this.scaleY * sy, this.shearX, this.shearY);
    }

    @Override
    public ILispAffineTransform2D shear(double sx, double sy) {
        return new LispDoubleLinearTransform2D(this.scaleX, this.scaleY, this.shearX * sx, this.shearY * sy);
    }

    @Override
    public ILispAffineTransform2D translate(double tx, double ty) {
        return new LispDoubleAffineTransform2D(this.scaleX, this.scaleY, this.shearX, this.shearY, tx, ty);
    }

    @Override
    public ILispAffineTransform2D reflectX() {
        return new LispDoubleLinearTransform2D(this.scaleX, -this.scaleY, this.shearX, this.shearY);
    }

    @Override
    public ILispAffineTransform2D reflectY() {
        return new LispDoubleLinearTransform2D(-this.scaleX, this.scaleY, this.shearX, this.shearY);
    }

    @Override
    public ILispAffineTransform2D squeeze(double k) {
        return new LispDoubleLinearTransform2D(this.scaleX * k, this.scaleY / k, this.shearX, this.shearY);
    }

    @Override
    public ILispAffineTransform2D concatenate(ILispAffineTransform2D t) {
        if (t instanceof LispDoubleLinearTransform2D) {
            LispDoubleLinearTransform2D z = (LispDoubleLinearTransform2D)t;
            return new LispDoubleLinearTransform2D(this.scaleX * z.scaleX + this.shearX * z.shearY, this.shearY * z.shearX + this.scaleY * z.scaleY, this.scaleX * z.shearX + this.shearX * z.scaleY, this.shearY * z.scaleX + this.scaleY * z.shearY);
        }
        LispDoubleAffineTransform2D z = (LispDoubleAffineTransform2D)t;
        return new LispDoubleAffineTransform2D(this.scaleX * z.getScaleXDouble() + this.shearX * z.getShearYDouble(), this.shearY * z.getShearXDouble() + this.scaleY * z.getScaleYDouble(), this.scaleX * z.getShearXDouble() + this.shearX * z.getScaleYDouble(), this.shearY * z.getScaleXDouble() + this.scaleY * z.getShearYDouble(), this.scaleX * z.getTranslateXDouble() + this.shearX * z.getTranslateYDouble(), this.shearY * z.getTranslateXDouble() + this.scaleY * z.getTranslateYDouble());
    }
}

