/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.analysis;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.analysis.ILispFunction1;
import net.morilib.lisp.math.analysis.ILispIntegrable1;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class LispDeltaFunction
extends UnaryArgs
implements ILispFunction1,
ILispIntegrable1 {
    private LispReal k0;

    public LispDeltaFunction(LispReal real) {
        this.k0 = real;
    }

    @Override
    public LispReal integrate(LispReal a, LispReal b) {
        return a.compareTo(this.k0) <= 0 && b.compareTo(this.k0) >= 0 ? LispInteger.ONE : LispInteger.ZERO;
    }

    @Override
    public LispNumber substitute(LispNumber x) {
        return x.isEqualTo(this.k0) ? LispDouble.POSITIVE_INFINITY : LispInteger.ZERO;
    }

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        return this.substitute(SubrUtils.getReal(c1a, mesg));
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("delta(x - ").append(this.k0.print()).append(")");
    }
}

