/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lib.srfi094;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.math.Math2;

public class IntegerExpt
extends BinaryArgs {
    private static final BigInteger LIMIT_INT = BigInteger.valueOf(Integer.MAX_VALUE);

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof LispInteger)) {
            throw mesg.getError("err.require.int", c1a);
        }
        if (!(c2a instanceof LispInteger)) {
            throw mesg.getError("err.require.int", c2a);
        }
        BigInteger b1 = c1a.getBigInteger();
        BigInteger b2 = c2a.getBigInteger();
        if (b2.signum() < 0) {
            throw mesg.getError("err.srfi94.outofdomain", c2a);
        }
        if (b2.signum() == 0) {
            return LispInteger.ZERO;
        }
        if (b1.signum() == 0) {
            return LispInteger.ZERO;
        }
        if (b1.equals(BigInteger.ONE)) {
            return LispInteger.ONE;
        }
        if (b2.compareTo(LIMIT_INT) <= 0) {
            return LispInteger.valueOf(b1.pow(b2.intValue()));
        }
        return LispInteger.valueOf(Math2.pow(b1, b2));
    }
}

