/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.iterator.ILispIterator;

public class LispListGroupIterator
extends Datum2
implements ILispIterator {
    private Datum[] lists;
    private List<Set<Datum>> memos;

    LispListGroupIterator(boolean dummy, Datum[] lists) {
        this.lists = lists;
        this.memos = new ArrayList<Set<Datum>>();
        int i = 0;
        while (i < lists.length) {
            this.memos.add(new HashSet());
            ++i;
        }
    }

    public LispListGroupIterator(Datum ... lists) {
        this(false, LispListGroupIterator._c(lists));
    }

    private static Datum[] _c(Datum[] lists) {
        Datum[] r = new Datum[lists.length];
        System.arraycopy(lists, 0, r, 0, r.length);
        return r;
    }

    private boolean isAllCirculated() {
        for (Set<Datum> d : this.memos) {
            if (d == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        if (this.lists.length == 0) {
            return true;
        }
        Datum[] datumArray = this.lists;
        int n = this.lists.length;
        int n2 = 0;
        while (n2 < n) {
            Datum itr = datumArray[n2];
            if (itr.isNil()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ILispIterator next() {
        int i = 0;
        while (i < this.lists.length) {
            if (this.lists[i].isNil()) {
                throw new NoSuchElementException();
            }
            if (!(this.lists[i] instanceof Cons)) {
                throw new NoSuchElementException();
            }
            if (this.memos.get(i) != null && this.memos.get(i).contains(this.lists[i])) {
                this.memos.set(i, null);
            }
            if (this.isAllCirculated()) {
                throw new NoSuchElementException();
            }
            if (this.memos.get(i) != null) {
                this.memos.get(i).add(this.lists[i]);
            }
            this.lists[i] = ((Cons)this.lists[i]).getCdr();
            ++i;
        }
        return this;
    }

    @Override
    public Datum getCurrentDatum() {
        ConsListBuilder b = new ConsListBuilder();
        Datum[] datumArray = this.lists;
        int n = this.lists.length;
        int n2 = 0;
        while (n2 < n) {
            Datum d = datumArray[n2];
            if (d.isNil()) {
                throw new NoSuchElementException();
            }
            if (!(d instanceof Cons)) {
                throw new NoSuchElementException();
            }
            b.append(((Cons)d).getCar());
            ++n2;
        }
        return b.get();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<list-group-iterator>");
    }
}

