/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;
import net.morilib.util.primitive.IntegerArrayVector;

public class MakeArray
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum s = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (s instanceof LispArrayShape) {
            Datum o = Iterators.nextIf(itr, Undef.UNDEF);
            SubrUtils.checkTerminated(itr, body, mesg);
            return LispDefaultArray.malloc((LispArrayShape)s, o);
        }
        if (s instanceof LispArrayPrototype) {
            IntegerArrayVector bin = new IntegerArrayVector();
            while (itr.hasNext()) {
                int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
                if (b < 0) {
                    throw mesg.getError("err.srfi25.arraysize.invalid", LispInteger.valueOf(b));
                }
                bin.add(b);
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            return (Datum)((Object)((LispArrayPrototype)((Object)s)).makeArray(bin.toIntArray()));
        }
        throw mesg.getError("err.srfi25.require.shape", s);
    }
}

