/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.array.SRFI47Array;

public class LispCharArray
extends SRFI47Array
implements Serializable {
    private char[] chr;

    public LispCharArray(char r, int ... is) {
        super(is);
        this.chr = new char[LispArrayShape.arraylength(is)];
        Arrays.fill(this.chr, r);
    }

    @Override
    public int rank() {
        return this.eIndices.length;
    }

    @Override
    public int startIndex(int dim) {
        if (dim < 0 || dim >= this.eIndices.length) {
            throw new IndexOutOfBoundsException();
        }
        return 0;
    }

    @Override
    public int endIndex(int dim) {
        return this.eIndices[dim];
    }

    @Override
    public LispVector toVector() {
        Datum[] r = new Datum[LispArrayShape.arraylength(this.eIndices)];
        int i = 0;
        while (i < r.length) {
            r[i] = LispCharacter.valueOf(this.chr[i]);
            ++i;
        }
        return new LispVector(r);
    }

    @Override
    public Datum getFromArray(int ... is) {
        return LispCharacter.valueOf(this.chr[LispArrayShape.arrayindex(this.eIndices, is)]);
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        if (!(d instanceof LispCharacter)) {
            throw new ClassCastException();
        }
        this.chr[LispArrayShape.arrayindex((int[])this.eIndices, (int[])is)] = d.getCharacter();
    }

    @Override
    public boolean isEqualTo(ILispArray a) {
        if (!this.isIndexEqualTo(a)) {
            return false;
        }
        if (a instanceof LispCharArray) {
            return Arrays.equals(this.chr, ((LispCharArray)a).chr);
        }
        return LispDefaultArray.isEqualTo(this, a);
    }

    @Override
    public String getTypeSpecifier() {
        return "char";
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int i = 0;
        while (i < this.chr.length && itr.hasNext()) {
            Datum x = itr.next();
            if (!(x instanceof LispCharacter)) {
                throw new ClassCastException();
            }
            this.chr[i] = x.getCharacter();
            ++i;
        }
    }
}

