/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum3;
import net.morilib.lisp.Environment;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.JavaNull;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.SExpression;
import net.morilib.lisp.SExpressionDatum;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.datetime.LispDate;
import net.morilib.lisp.uvector.HomogeneousArray;
import net.morilib.util.ArrayListStack;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.table.ArrayTable;
import net.morilib.util.table.Table;

public final class LispUtils {
    private static final Datum _STK_CONS = new DumDatum();
    private static final Datum _STK_CNS2 = new DumDatum();
    private static final Datum _STK_VEC1 = new DumDatum();
    private static final Datum _STK_VEC2 = new DumDatum();
    private static final Datum _STK_MLT1 = new DumDatum();
    private static final CallTable<Table<Datum>, Datum> _MAKETBL = new CallTable<Table<Datum>, Datum>(){

        @Override
        public Table<Datum> create(int rows, int cols) {
            return new ArrayTable<Datum>(rows, cols);
        }

        @Override
        public void call(Table<Datum> tbl, int r, int c, Datum t) {
            tbl.set(r, c, t);
        }
    };

    private LispUtils() {
    }

    public static boolean detectCirculate(Datum s) {
        Stack<Datum> st = new Stack<Datum>();
        IdentityHashMap<Datum, Integer> e1 = new IdentityHashMap<Datum, Integer>();
        st.push(s);
        while (!st.isEmpty()) {
            Datum r = (Datum)st.pop();
            if (r instanceof Cons) {
                Cons c = (Cons)r;
                if (c.getCar() == s) {
                    return true;
                }
                if (!e1.containsKey(c.getCar())) {
                    st.push(c.getCar());
                    e1.put(c.getCar(), 0);
                }
                if (c.getCdr() == s) {
                    return true;
                }
                if (e1.containsKey(c.getCdr())) continue;
                st.push(c.getCdr());
                e1.put(c.getCdr(), 0);
                continue;
            }
            if (!(r instanceof LispVector)) continue;
            LispVector v = (LispVector)r;
            int i = 0;
            while (i < ((LispVector)r).size()) {
                if (v.get(i) == s) {
                    return true;
                }
                e1.containsKey(v.get(i));
                e1.put(v.get(i), 0);
                ++i;
            }
        }
        return false;
    }

    private static void printBody(Datum dt, StringBuilder buf, boolean met, Map<Datum, Object> eq, boolean s38) {
        ArrayListStack<Datum> st = new ArrayListStack<Datum>();
        int num = 0;
        st.push(dt);
        while (!st.isEmpty()) {
            Object a;
            Datum d = (Datum)st.pop();
            if (d instanceof ILispArray && !(d instanceof LispVector)) {
                a = (ILispArray)((Object)d);
                int[] is = new int[a.rank()];
                buf.append('#');
                buf.append(a.rank());
                buf.append('A');
                if (a.rank() > 0) {
                    int i = 0;
                    while (i < a.rank()) {
                        if (i > 0) {
                            buf.append('*');
                        }
                        buf.append(a.endIndex(i) - a.startIndex(i));
                        is[i] = a.startIndex(i);
                        ++i;
                    }
                    if (a.getTypeSpecifier() != null) {
                        buf.append(':');
                        buf.append(a.getTypeSpecifier());
                    }
                    LispUtils._append((ILispArray)a, buf, eq, met, s38, 0, is);
                    continue;
                }
                if (a.getTypeSpecifier() != null) {
                    buf.append(':');
                    buf.append(a.getTypeSpecifier());
                }
                buf.append(' ');
                LispUtils.printBody(a.getFromArray(new int[0]), buf, met, eq, s38);
                continue;
            }
            if (d instanceof Atom) {
                a = (Atom)d;
                buf.append(met ? ((Atom)a).getResult() : ((Atom)a).print());
                continue;
            }
            if (s38 && eq.containsKey(d)) {
                buf.append("#" + eq.get(d) + "#");
                continue;
            }
            if (d instanceof Cons) {
                Cons cd;
                Cons c = (Cons)d;
                if (s38 && LispUtils.detectCirculate(d)) {
                    buf.append("#" + num + "=");
                    eq.put(d, num++);
                }
                if ((Symbol.QUOTE.equals(c.getCar()) || Symbol.QUASIQUOTE.equals(c.getCar()) || Symbol.UNQUOTE.equals(c.getCar()) || Symbol.UNQUOTE_SPLICING.equals(c.getCar())) && c.getCdr() instanceof Cons && (cd = (Cons)c.getCdr()).getCdr() == Nil.NIL) {
                    if (Symbol.QUOTE.equals(c.getCar())) {
                        buf.append("'");
                    } else if (Symbol.QUASIQUOTE.equals(c.getCar())) {
                        buf.append("`");
                    } else if (Symbol.UNQUOTE.equals(c.getCar())) {
                        buf.append(",");
                    } else if (Symbol.UNQUOTE_SPLICING.equals(c.getCar())) {
                        buf.append(",@");
                    }
                    st.push(cd.getCar());
                    continue;
                }
                buf.append("(");
                st.push(c.getCdr());
                st.push(_STK_CONS);
                st.push(c.getCar());
                continue;
            }
            if (d instanceof LispVector) {
                LispVector v = (LispVector)d;
                if (s38 && LispUtils.detectCirculate(d)) {
                    buf.append("#" + num + "=");
                    eq.put(d, num++);
                }
                buf.append("#(");
                st.push(_STK_VEC2);
                int i = v.size() - 1;
                while (i >= 0) {
                    st.push(v.get(i));
                    if (i > 0) {
                        st.push(_STK_VEC1);
                    }
                    --i;
                }
                continue;
            }
            if (d instanceof MultiValues) {
                List<Datum> lst = ((MultiValues)d).getValues();
                int i = lst.size() - 1;
                while (i >= 0) {
                    st.push(lst.get(i));
                    if (i > 0) {
                        st.push(_STK_MLT1);
                    }
                    --i;
                }
                continue;
            }
            if (d instanceof SymbolScope) {
                SymbolScope d2 = (SymbolScope)d;
                Symbol a2 = d2.getSymbol();
                buf.append(met ? a2.getResult() : a2.print());
                continue;
            }
            if (d == _STK_CONS) {
                Datum e = (Datum)st.pop();
                if (s38 && eq.containsKey(e)) {
                    buf.append(" . #" + eq.get(e) + "#)");
                    continue;
                }
                if (e instanceof Cons) {
                    buf.append(" ");
                    st.push(((Cons)e).getCdr());
                    st.push(_STK_CONS);
                    st.push(((Cons)e).getCar());
                    continue;
                }
                if (e.isNil()) {
                    buf.append(")");
                    continue;
                }
                buf.append(" . ");
                st.push(_STK_CNS2);
                st.push(e);
                continue;
            }
            if (d == _STK_CNS2) {
                buf.append(")");
                continue;
            }
            if (d == _STK_VEC1) {
                buf.append(" ");
                continue;
            }
            if (d == _STK_VEC2) {
                buf.append(")");
                continue;
            }
            if (d == _STK_MLT1) {
                buf.append("\n");
                continue;
            }
            if (d instanceof Datum3) {
                if (met) {
                    ((Datum3)d).getResult(buf);
                    continue;
                }
                ((Datum3)d).print(buf);
                continue;
            }
            d.toDisplayString(buf);
        }
    }

    private static void _append(ILispArray a, StringBuilder b, Map<Datum, Object> eq, boolean met, boolean s38, int dp, int[] is) {
        if (dp == is.length) {
            LispUtils.printBody(a.getFromArray(is), b, met, s38);
        } else {
            b.append("(");
            while (is[dp] < a.endIndex(dp)) {
                if (is[dp] > a.startIndex(dp)) {
                    b.append(" ");
                }
                LispUtils._append(a, b, eq, met, s38, dp + 1, is);
                int n = dp;
                is[n] = is[n] + 1;
            }
            b.append(")");
            is[dp] = a.startIndex(dp);
        }
    }

    private static void printBody(Datum d, StringBuilder buf, boolean b, boolean c) {
        LispUtils.printBody(d, buf, b, new IdentityHashMap<Datum, Object>(), c);
    }

    public static String print(Datum d) {
        StringBuilder buf = new StringBuilder();
        LispUtils.printBody(d, buf, false, true);
        return buf.toString();
    }

    public static String getResult(Datum d) {
        StringBuilder buf = new StringBuilder();
        LispUtils.printBody(d, buf, true, true);
        return buf.toString();
    }

    public static String printWithoutSS(Datum d) {
        StringBuilder buf = new StringBuilder();
        LispUtils.printBody(d, buf, false, false);
        return buf.toString();
    }

    public static String getResultWithoutSS(Datum d) {
        StringBuilder buf = new StringBuilder();
        LispUtils.printBody(d, buf, true, false);
        return buf.toString();
    }

    public static Datum listToCons(Collection<? extends Datum> d, Datum dot) {
        Cons res = null;
        Cons c2 = null;
        for (Datum datum : d) {
            if (res == null) {
                res = c2 = new Cons();
                c2.setCar(datum);
                continue;
            }
            Cons c3 = new Cons(datum, Nil.NIL);
            c2.setCdr(c3);
            c2 = c3;
        }
        if (res == null) {
            return dot;
        }
        c2.setCdr(dot);
        return res;
    }

    public static Datum listToCons(Collection<? extends Datum> d) {
        return LispUtils.listToCons(d, Nil.NIL);
    }

    public static Datum toCons(Iterable<? extends Datum> d, Datum dot) {
        Cons res = null;
        Cons c2 = null;
        for (Datum datum : d) {
            if (res == null) {
                res = c2 = new Cons();
                c2.setCar(datum);
                continue;
            }
            Cons c3 = new Cons(datum, Nil.NIL);
            c2.setCdr(c3);
            c2 = c3;
        }
        if (res == null) {
            return dot;
        }
        c2.setCdr(dot);
        return res;
    }

    public static Datum toCons(Iterable<? extends Datum> d) {
        return LispUtils.toCons(d, Nil.NIL);
    }

    public static List<Datum> consToList(Datum d, LispMessage mesg) {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum dd = d;
        while (dd != Nil.NIL) {
            if (dd instanceof Cons) {
                res.add(((Cons)dd).getCar());
                dd = ((Cons)dd).getCdr();
                continue;
            }
            throw mesg.getError("err.list");
        }
        return res;
    }

    public static List<Datum> consToListIgnoreDot(Datum d) {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum dd = d;
        while (dd != Nil.NIL) {
            if (!(dd instanceof Cons)) break;
            res.add(((Cons)dd).getCar());
            dd = ((Cons)dd).getCdr();
        }
        return res;
    }

    public static Datum[] consToArray(Datum d, LispMessage mesg) {
        return LispUtils.consToList(d, mesg).toArray(new Datum[0]);
    }

    public static <C> C consToTable(Datum d, LispMessage mesg, CallTable<C, Datum> call) {
        int c = -1;
        int r = 0;
        ConsIterator ity = new ConsIterator(d);
        while (ity.hasNext()) {
            int x2 = 0;
            Datum d2 = ity.next();
            if (!(d2 instanceof Cons)) {
                throw mesg.getError("err.require.list", d2);
            }
            ConsIterator itx = new ConsIterator(d2);
            while (itx.hasNext()) {
                itx.next();
                ++x2;
            }
            if (!itx.getTerminal().isNil()) {
                throw mesg.getError("err.list", d2);
            }
            if (c < 0) {
                c = x2;
            } else if (c != x2) {
                throw mesg.getError("err.table.malform.column", d2);
            }
            ++r;
        }
        if (!ity.getTerminal().isNil()) {
            throw mesg.getError("err.list", d);
        }
        C res = call.create(r, c);
        ity = new ConsIterator(d);
        r = 0;
        while (ity.hasNext()) {
            ConsIterator itx = new ConsIterator(ity.next());
            c = 0;
            while (itx.hasNext()) {
                call.call(res, r, c, itx.next());
                ++c;
            }
            ++r;
        }
        return res;
    }

    public static Table<Datum> consToTable(Datum d, LispMessage mesg) {
        return LispUtils.consToTable(d, mesg, _MAKETBL);
    }

    public static int consLength(Datum d) {
        Datum p = d;
        int len = 0;
        while (p != Nil.NIL) {
            if (p instanceof Cons) {
                Cons c = (Cons)p;
                ++len;
                p = c.getCdr();
                continue;
            }
            return len;
        }
        return len;
    }

    public static List<Datum> toList(Object[] arr) {
        ArrayList<Datum> lst = new ArrayList<Datum>();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            lst.add(LispUtils.toDatum(o));
            ++n2;
        }
        return lst;
    }

    public static Datum toConsList(Object[] arr, Object cdr) {
        ConsListBuilder lst = new ConsListBuilder();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            lst.append(LispUtils.toDatum(o));
            ++n2;
        }
        return lst.get(LispUtils.toDatum(cdr));
    }

    public static Datum toConsList(Object[] arr) {
        return LispUtils.toConsList(arr, Nil.NIL);
    }

    public static LispExactReal bigDecimalToRational(BigDecimal v) {
        BigInteger n = v.unscaledValue();
        if (v.scale() > 0) {
            BigInteger d = BigInteger.TEN.pow(v.scale());
            return LispRational.newRational(n, d);
        }
        if (v.scale() < 0) {
            BigInteger d = BigInteger.TEN.pow(-v.scale());
            return LispInteger.valueOf(n.multiply(d));
        }
        return LispInteger.valueOf(n);
    }

    public static Datum toDatum(Object o) {
        Class<?> cl;
        Class<?> clazz = cl = o == null ? null : o.getClass();
        if (o == null) {
            return JavaNull.JAVA_NULL;
        }
        if (o instanceof Datum) {
            return (Datum)o;
        }
        if (o instanceof Byte) {
            return LispInteger.valueOf(((Byte)o).intValue());
        }
        if (o instanceof Short) {
            return LispInteger.valueOf(((Short)o).intValue());
        }
        if (o instanceof Integer) {
            return LispInteger.valueOf((Integer)o);
        }
        if (o instanceof Long) {
            return LispInteger.valueOf((Long)o);
        }
        if (o instanceof BigInteger) {
            return LispInteger.valueOf((BigInteger)o);
        }
        if (o instanceof BigDecimal) {
            return LispUtils.bigDecimalToRational((BigDecimal)o);
        }
        if (o instanceof Float) {
            return new LispDouble(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return new LispDouble((Double)o);
        }
        if (o instanceof String) {
            return new LispString((String)o);
        }
        if (o instanceof Character) {
            return new LispCharacter(((Character)o).charValue());
        }
        if (o instanceof Boolean) {
            return LispBoolean.getInstance((Boolean)o);
        }
        if (cl.isArray()) {
            ConsListBuilder bld = new ConsListBuilder();
            int len = Array.getLength(o);
            int i = 0;
            while (i < len) {
                bld.append(LispUtils.toDatum(Array.get(o, i)));
                ++i;
            }
            return bld.get();
        }
        return new JavaInstance(o);
    }

    public static boolean eqv(Datum d1, Datum d2) {
        return !LispBoolean.FALSE.equals(d1.isEqv(d2));
    }

    public static boolean equals(Datum d, String o) {
        if (d instanceof LispString) {
            return ((LispString)d).getString().equals(o);
        }
        return false;
    }

    public static boolean eqvExact(Datum d, BigInteger v) {
        if (d instanceof LispInteger) {
            return d.getBigInteger().equals(v);
        }
        return false;
    }

    public static boolean eqvExact(Datum d, int v) {
        return LispUtils.eqvExact(d, BigInteger.valueOf(v));
    }

    public static boolean eqvExact(Datum d, long v) {
        return LispUtils.eqvExact(d, BigInteger.valueOf(v));
    }

    public static boolean eqvInexact(Datum d, double v) {
        if (d instanceof LispReal) {
            return ((LispReal)d).getRealDouble() == v;
        }
        return false;
    }

    public static boolean eqvInexact(Datum d, Number v) {
        return LispUtils.eqvInexact(d, v.doubleValue());
    }

    public static boolean eqvInexact(Datum d, int v) {
        return LispUtils.eqvInexact(d, (double)v);
    }

    public static boolean eqvInexact(Datum d, long v) {
        return LispUtils.eqvInexact(d, (double)v);
    }

    public static Datum listDot(Object d, Object ... lst) {
        ConsListBuilder b = new ConsListBuilder();
        Object[] objectArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            b.append(LispUtils.toDatum(o));
            ++n2;
        }
        return b.get(LispUtils.toDatum(d));
    }

    public static Datum list(Object ... lst) {
        return LispUtils.listDot((Object)Nil.NIL, lst);
    }

    public static Datum listDot(Datum d, Datum ... lst) {
        ConsListBuilder b = new ConsListBuilder();
        Datum[] datumArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Datum o = datumArray[n2];
            b.append(o);
            ++n2;
        }
        return b.get(d);
    }

    public static Datum list(Datum ... lst) {
        return LispUtils.listDot(Nil.NIL, lst);
    }

    public static Cons cons(Object car, Object cdr) {
        return new Cons(LispUtils.toDatum(car), LispUtils.toDatum(cdr));
    }

    public static LispVector vector(Object ... lst) {
        ArrayList<Datum> v = new ArrayList<Datum>();
        Object[] objectArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            v.add(LispUtils.toDatum(o));
            ++n2;
        }
        return new LispVector(v);
    }

    public static boolean equalsVector(LispVector v1, LispVector v2) {
        if (v1.size() != v2.size()) {
            return false;
        }
        int i = 0;
        while (i < v1.size()) {
            if (!LispUtils.equal(v1.get(i), v2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean equal(Datum d1, Datum d2) {
        Datum p = d1;
        Datum q = d2;
        while (p instanceof Cons) {
            Cons pc = (Cons)p;
            if (q instanceof Cons) {
                Cons qc = (Cons)q;
                if (LispUtils.equal(pc.getCar(), qc.getCar())) {
                    p = pc.getCdr();
                    q = qc.getCdr();
                    continue;
                }
                return false;
            }
            return false;
        }
        if (p instanceof LispString) {
            if (q instanceof LispString) {
                String s1 = ((LispString)p).getString();
                String s2 = ((LispString)q).getString();
                return s1.equals(s2);
            }
            return false;
        }
        if (p instanceof LispVector) {
            if (q instanceof LispVector) {
                return LispUtils.equalsVector((LispVector)p, (LispVector)q);
            }
            return false;
        }
        if (p instanceof HomogeneousArray) {
            return q instanceof HomogeneousArray && ((HomogeneousArray)((Object)p)).equalsArray(p, q);
        }
        return p.isEqv(q);
    }

    public static boolean equals(Datum a, Datum b) {
        ArrayListStack<Datum> s1 = new ArrayListStack<Datum>();
        ArrayListStack<Datum> s2 = new ArrayListStack<Datum>();
        IdentityHashMap<Datum, Integer> e1 = new IdentityHashMap<Datum, Integer>();
        IdentityHashMap<Datum, Integer> e2 = new IdentityHashMap<Datum, Integer>();
        int num = 0;
        s1.push(a);
        s2.push(b);
        while (!s1.isEmpty()) {
            Datum y;
            Datum x = (Datum)s1.pop();
            if (!(x == (y = (Datum)s2.pop()) || e1.containsKey(x) && e2.containsKey(y) && e1.get(x) == e2.get(y))) {
                if (x instanceof Cons && y instanceof Cons) {
                    s1.push(((Cons)x).getCdr());
                    s1.push(((Cons)x).getCar());
                    s2.push(((Cons)y).getCdr());
                    s2.push(((Cons)y).getCar());
                } else if (x instanceof LispVector && y instanceof LispVector) {
                    LispVector xv = (LispVector)x;
                    LispVector yv = (LispVector)y;
                    if (xv.size() != yv.size()) {
                        return false;
                    }
                    int i = xv.size() - 1;
                    while (i >= 0) {
                        s1.push(xv.get(i));
                        s2.push(yv.get(i));
                        --i;
                    }
                } else if (x instanceof LispString && y instanceof LispString) {
                    if (!x.getString().equals(y.getString())) {
                        return false;
                    }
                } else {
                    if (x instanceof HomogeneousArray) {
                        return y instanceof HomogeneousArray && ((HomogeneousArray)((Object)x)).equalsArray(x, y);
                    }
                    if (x instanceof ILispArray) {
                        return y instanceof ILispArray && ((ILispArray)((Object)x)).isEqualTo((ILispArray)((Object)y));
                    }
                    if (!x.equals(y)) {
                        return false;
                    }
                }
            }
            e1.put(x, num);
            e2.put(y, num);
            ++num;
        }
        return true;
    }

    public static Map<Datum, Datum> assocToMap(Datum d) {
        HashMap<Datum, Datum> res = new HashMap<Datum, Datum>();
        ConsIterator p = new ConsIterator(d);
        while (p.hasNext()) {
            Datum c = p.next();
            if (c instanceof Cons) {
                Cons c0 = (Cons)c;
                res.put(c0.getCar(), c0.getCdr());
                continue;
            }
            return null;
        }
        return p.getTerminal() == Nil.NIL ? res : null;
    }

    public static Map<Symbol, Datum> assocToMapSymbol(Datum d) {
        HashMap<Symbol, Datum> res = new HashMap<Symbol, Datum>();
        ConsIterator p = new ConsIterator(d);
        while (p.hasNext()) {
            Datum c = p.next();
            if (c instanceof Cons) {
                Cons c0 = (Cons)c;
                if (c0.getCar() instanceof SymbolName) {
                    res.put(((SymbolName)((Object)c0.getCar())).getSymbol(), c0.getCdr());
                    continue;
                }
                return null;
            }
            return null;
        }
        return p.getTerminal() == Nil.NIL ? res : null;
    }

    public static void checkReal(Datum d, LispMessage mesg) {
        if (!(d instanceof LispNumber)) {
            throw mesg.getError("err.require.number", d);
        }
        if (!((LispNumber)d).isReal()) {
            throw mesg.getError("err.require.real", d);
        }
    }

    public static void checkReal(List<Datum> l, int i, LispMessage mesg) {
        LispUtils.checkReal(l.get(i), mesg);
    }

    public static void checkString(Datum d, LispMessage mesg) {
        if (!(d instanceof LispString)) {
            throw mesg.getError("err.require.string", d);
        }
    }

    public static void checkSymbol(Datum d, LispMessage mesg) {
        if (!(d instanceof Symbol)) {
            throw mesg.getError("err.require.symbol", d);
        }
    }

    public static Datum[] toArray(Datum d, LispMessage mesg) {
        return LispUtils.consToList(d, mesg).toArray(new Datum[0]);
    }

    public static Cons copy(Iterator<Datum> itr, Datum d) {
        Cons r = null;
        Cons r0 = null;
        while (itr.hasNext()) {
            if (r == null) {
                r = r0 = new Cons();
            } else {
                r.setCdr(new Cons());
                r = (Cons)r.getCdr();
            }
            r.setCar(itr.next());
        }
        if (r0 != null) {
            r.setCdr(d);
        }
        return r0;
    }

    public static Set<Datum> toSetEqv(Iterator<Datum> itr) {
        HashSet<Datum> d = new HashSet<Datum>();
        while (itr.hasNext()) {
            d.add(itr.next());
        }
        return d;
    }

    public static List<Datum> toList(Iterator<Datum> itr) {
        ArrayList<Datum> d = new ArrayList<Datum>();
        while (itr.hasNext()) {
            d.add(itr.next());
        }
        return d;
    }

    public static Datum toAlist(Iterator<Map.Entry<Datum, Datum>> itr) {
        ConsListBuilder b = new ConsListBuilder();
        while (itr.hasNext()) {
            Map.Entry<Datum, Datum> e = itr.next();
            b.append(new Cons(e.getKey(), e.getValue()));
        }
        return b.get();
    }

    public static Cons nconc(Cons a, Datum b) {
        Cons p = a;
        while (p.getCdr() instanceof Cons) {
            p = (Cons)p.getCdr();
        }
        p.setCdr(b);
        return a;
    }

    public static Datum stringToList(CharSequence cs) {
        ConsListBuilder b = new ConsListBuilder();
        int i = 0;
        while (i < cs.length()) {
            b.append(LispCharacter.valueOf(cs.charAt(i)));
            ++i;
        }
        return b.get();
    }

    public static boolean contains(SExpression p, Datum x, Procedure proc, Environment env, LispMessage mesg) {
        for (Datum y : p) {
            if (!Scheme.callva(proc, env, mesg, x, y).isTrue()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAsSet(SExpressionDatum p, SExpressionDatum q, Procedure proc, Environment env, LispMessage mesg) {
        for (Datum x : q) {
            if (LispUtils.contains(p, x, proc, env, mesg)) continue;
            return false;
        }
        return true;
    }

    public static long length(Datum dd) {
        IdentityHashMap<Datum, Datum> eq = new IdentityHashMap<Datum, Datum>();
        long l = 0L;
        while (!dd.isNil()) {
            if (eq.containsKey(dd)) {
                return -1L;
            }
            if (dd instanceof Cons) {
                ++l;
                eq.put(dd, dd);
                dd = ((Cons)dd).getCdr();
                continue;
            }
            return -2L;
        }
        return l;
    }

    public static boolean isProperList(Datum x) {
        return LispUtils.length(x) >= 0L;
    }

    public static boolean isProperListNotNil(Datum x) {
        return LispUtils.length(x) > 0L;
    }

    public static Datum take(Datum x, int n) {
        Datum x1 = x;
        SExpressionDatum rp = null;
        Nil r0 = null;
        int i = 0;
        while (i < n) {
            if (x1 instanceof Cons) {
                if (r0 == null) {
                    rp = new Cons();
                    r0 = rp;
                } else {
                    ((Cons)rp).setCdr(new Cons());
                    rp = (Cons)((Cons)rp).getCdr();
                }
            } else {
                if (r0 == null) {
                    return x1;
                }
                ((Cons)rp).setCdr(x1);
                return r0;
            }
            ((Cons)rp).setCar(((Cons)x1).getCar());
            ((Cons)rp).setCdr(Nil.NIL);
            x1 = ((Cons)x1).getCdr();
            ++i;
        }
        return r0 != null ? r0 : Nil.NIL;
    }

    public static Datum mul(Datum x, Datum y) {
        return x.isNil() || y.isNil() ? Nil.NIL : new Cons(x, y);
    }

    public static boolean isProduct(Datum x) {
        ArrayListStack<Datum> s = new ArrayListStack<Datum>();
        HashSet<Datum> t = new HashSet<Datum>();
        s.push(x);
        while (s.isEmpty()) {
            Datum d = (Datum)s.pop();
            if (t.contains(d)) {
                return false;
            }
            if (d instanceof Cons) {
                s.push(((Cons)d).getCdr());
                s.push(((Cons)d).getCar());
                t.add(d);
                continue;
            }
            if (!d.isNil()) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static Datum append(Datum x, Datum y) {
        b = new ConsListBuilder();
        itr = new ConsIterator(x);
        if (!(x instanceof Cons) || !(y instanceof Cons)) {
            return null;
        }
        if (x.isNilUnit()) {
            return y;
        }
        if (!y.isNilUnit()) ** GOTO lbl11
        return x;
lbl-1000:
        // 1 sources

        {
            b.append(itr.next());
lbl11:
            // 2 sources

            ** while (itr.hasNext())
        }
lbl12:
        // 1 sources

        return itr.getTerminal().isNil() != false ? b.get(y) : null;
    }

    public static Datum add(Datum x, Datum y) {
        if (x.isNil()) {
            return y;
        }
        if (y.isNil()) {
            return x;
        }
        Datum lx = LispUtils.isProperList(x) ? x : LispUtils.list(x);
        Datum ly = LispUtils.isProperList(y) ? y : LispUtils.list(y);
        return LispUtils.append(lx, ly);
    }

    public static Procedure mul(final Procedure x, final Procedure y) {
        return new Subr("synthesized procedure"){

            @Override
            public Datum eval(Datum body, Environment env, LispMessage mesg) {
                Datum ry = Scheme.call(y, env, mesg, body);
                Datum[] ay = ry.getValues().toArray(new Datum[0]);
                return Scheme.callva(x, env, mesg, ay);
            }
        };
    }

    public static List<Datum> serializeCons(Datum d) {
        long l = 0L;
        ArrayList<Datum> r = new ArrayList<Datum>();
        ArrayListStack<Datum> s1 = new ArrayListStack<Datum>();
        HashOneToOneSet<Long, Datum> sc = new HashOneToOneSet<Long, Datum>();
        s1.add(d);
        while (!s1.isEmpty()) {
            Datum x = (Datum)s1.pop();
            if (sc.containsValue(x)) {
                long m = (Long)sc.getKey(x);
                r.add(new LabeledCons(x, l - m));
                continue;
            }
            if (x instanceof Cons) {
                sc.put(l++, x);
                r.add(new LabeledCons(x, -1L));
                s1.push(((Cons)x).getCdr());
                s1.push(((Cons)x).getCar());
                continue;
            }
            r.add(x);
        }
        return r;
    }

    public static boolean containsTopologically(Datum a, Datum b) {
        List<Datum> a1 = LispUtils.serializeCons(a);
        List<Datum> b1 = LispUtils.serializeCons(b);
        int i = 0;
        while (i <= a1.size() - b1.size()) {
            block3: {
                int j = i;
                while (j < b1.size()) {
                    if (a1.get(j).equals(b1.get(j))) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(Datum l, Datum d) {
        ArrayListStack<Datum> s1 = new ArrayListStack<Datum>();
        HashSet<Datum> sc = new HashSet<Datum>();
        s1.add(l);
        while (!s1.isEmpty()) {
            Datum x = (Datum)s1.pop();
            if (x.equals(d)) {
                return true;
            }
            if (sc.contains(x) || !(x instanceof Cons)) continue;
            sc.add(x);
            s1.push(((Cons)x).getCdr());
            s1.push(((Cons)x).getCar());
        }
        return false;
    }

    public static int countLeaves(Datum d) {
        ArrayListStack<Datum> s1 = new ArrayListStack<Datum>();
        HashSet<Datum> sc = new HashSet<Datum>();
        int l = 0;
        s1.add(d);
        while (!s1.isEmpty()) {
            Datum x = (Datum)s1.pop();
            if (sc.contains(x)) {
                return -1;
            }
            if (x instanceof Cons) {
                sc.add(x);
                s1.push(((Cons)x).getCdr());
                s1.push(((Cons)x).getCar());
                continue;
            }
            if (x.isNil()) continue;
            ++l;
        }
        return l;
    }

    public static Object toObject(Datum d, LispMessage mesg) {
        if (d instanceof JavaObjective) {
            return ((JavaObjective)((Object)d)).toObject();
        }
        throw mesg.getError("err.require.java-instance", d);
    }

    public static Datum toLispString(String s) {
        return s != null ? new LispString(s) : LispBoolean.FALSE;
    }

    public static Datum toPositiveInt(int x) {
        return x >= 0 ? LispInteger.valueOf(x) : LispBoolean.FALSE;
    }

    public static Datum toDate(long x) {
        return x != 0L ? new LispDate(x) : LispBoolean.FALSE;
    }

    public static boolean isReservedCharacter(char c) {
        return c == '(' || c == '[' || c == ')' || c == ']' || c == '#' || Character.isWhitespace(c);
    }

    public static BigInteger toIntegerExact(double number) {
        block3: {
            try {
                if (!Double.isInfinite(number) && !Double.isNaN(number)) break block3;
                return null;
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        BigDecimal dec = new BigDecimal(number);
        return dec.toBigIntegerExact();
    }

    public static Integer toIntExact(BigInteger i) {
        int r = i.intValue();
        if (i.equals(BigInteger.valueOf(r))) {
            return new Integer(r);
        }
        return null;
    }

    public static interface CallTable<C, T> {
        public C create(int var1, int var2);

        public void call(C var1, int var2, int var3, T var4);
    }

    private static class DumDatum
    extends Datum {
        private DumDatum() {
        }
    }

    private static class LabeledCons
    extends Datum {
        private long label;

        private LabeledCons(Datum c, long l) {
            this.label = l;
        }

        public int hashCode() {
            return (int)this.label;
        }

        public boolean equals(Object o) {
            if (o instanceof LabeledCons) {
                return this.label == ((LabeledCons)o).label;
            }
            return false;
        }
    }
}

