/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lang.Decimal32;
import net.morilib.lang.Decimal64;
import net.morilib.lang.DoubleUtils;
import net.morilib.lang.Half;
import net.morilib.lang.number.AbstractNumericalField;
import net.morilib.lang.number.Double2;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalField;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDecimal32;
import net.morilib.lisp.LispDecimal64;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispFloat;
import net.morilib.lisp.LispInexactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispRangedDouble;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;

public class LispHalf
extends LispInexactReal
implements JavaObjective,
Serializable {
    public static final NumericalField<LispReal> FIELD = new AbstractNumericalField<LispReal>(){

        @Override
        public LispReal valueOf(int v) {
            return this.valueOf((float)v);
        }

        @Override
        public LispReal valueOf(long v) {
            return this.valueOf((float)v);
        }

        @Override
        public LispReal valueOf(Integer2 v) {
            return this.valueOf(v.floatValue());
        }

        @Override
        public LispReal getUnit() {
            return LispFloat.ONE;
        }

        @Override
        public LispReal getZero() {
            return LispFloat.ZERO;
        }

        @Override
        public LispReal valueOf(float v) {
            return new LispHalf(DoubleUtils.toHalf(v));
        }

        @Override
        public LispReal valueOf(double v) {
            return this.valueOf((float)v);
        }

        @Override
        public LispReal valueOf(BigDecimal v) {
            return this.valueOf(v.floatValue());
        }

        @Override
        public LispReal valueOf(Rational v) {
            return this.valueOf(v.floatValue());
        }
    };
    public static final LispHalf ZERO = new LispHalf(0);
    public static final LispHalf ONE = new LispHalf(DoubleUtils.toHalf(1.0));
    public static final LispHalf POSITIVE_INFINITY = new LispHalf(31744);
    public static final LispHalf NEGATIVE_INFINITY = new LispHalf(-1024);
    public static final LispHalf NaN = new LispHalf(Short.MAX_VALUE);
    private short number;

    public LispHalf(short x) {
        this.number = x;
    }

    private static LispExactReal toExact(short val) {
        return LispDouble.toExact(Half.toDouble(val));
    }

    @Override
    public BigInteger getNumerator() {
        LispExactReal r = LispHalf.toExact(this.number);
        return r.getNumerator();
    }

    @Override
    public BigInteger getDenominator() {
        LispExactReal r = LispHalf.toExact(this.number);
        return r.getDenominator();
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble(Half.toDouble(this.number) + x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispFloat) {
            return new LispFloat(Half.toFloat(this.number) + x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble(Half.toDouble(this.number) + x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.add(Decimal32.toDecimal(Half.toDouble(this.number)), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.add(Decimal64.toDecimal(Half.toDouble(this.number)), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispHalf(Half.add(this.number, x.getRealHalf()));
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.add(c.getReal()), c.getImag());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.add(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.add(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble((double)Half.toFloat(this.number) - x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispFloat) {
            return new LispFloat(Half.toFloat(this.number) - x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble(Half.toDouble(this.number) - x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.subtract(Decimal32.toDecimal(Half.toDouble(this.number)), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.subtract(Decimal64.toDecimal(Half.toDouble(this.number)), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispHalf(Half.sub(this.number, x.getRealHalf()));
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.subtract(c.getReal()), c.getImag().uminus());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.sub(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.sub(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return LispRangedDouble.valueOf((double)Half.toFloat(this.number) * x.getRealDouble(), (double)Half.toFloat(this.number) * ((LispRangedDouble)x).error);
        }
        if (x instanceof LispFloat) {
            return new LispFloat(Half.toFloat(this.number) * x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble(Half.toDouble(this.number) * x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.multiply(Decimal32.toDecimal(Half.toDouble(this.number)), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.multiply(Decimal64.toDecimal(Half.toDouble(this.number)), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispHalf(Half.mul(this.number, x.getRealHalf()));
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.multiply(c.getReal()), this.multiply(c.getImag()));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.mul(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.mul(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            LispRangedDouble x0 = (LispRangedDouble)x;
            if (x0.isZeroIncluded()) {
                return LispDouble.NaN;
            }
            double y1 = this.doubleValue() / x0.getRealDouble() + this.doubleValue() * x0.error;
            double y2 = this.doubleValue() / x0.getRealDouble() - this.doubleValue() * x0.error;
            return LispRangedDouble.valueOf((y1 + y2) / 2.0, Math.abs(y1 - y2) / 2.0);
        }
        if (x instanceof LispFloat) {
            return new LispFloat(Half.toFloat(this.number) / x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble(Half.toDouble(this.number) / x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.divide(Decimal32.toDecimal(Half.toDouble(this.number)), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.divide(Decimal64.toDecimal(Half.toDouble(this.number)), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispHalf(Half.div(this.number, x.getRealHalf()));
        }
        if (x instanceof LispComplex) {
            LispReal xr = x.getReal();
            LispReal xi = x.getImag();
            LispReal xn = xr.multiply(xr).add(xi.multiply(xi));
            if (x == LispComplex.INFINITY) {
                return this.isExact() ? LispInteger.ZERO : LispDouble.ZERO;
            }
            return LispComplex.newComplex(this.multiply(xr).divide(xn), this.multiply(xi).uminus().divide(xn));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.div(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.div(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispFloat uminus() {
        return new LispFloat(Half.neg(this.number));
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispHalf) {
            return this.number == x.getRealHalf();
        }
        if (x instanceof LispFloat) {
            return this.number == x.getRealHalf();
        }
        if (x instanceof LispDouble) {
            return this.number == x.getRealHalf();
        }
        if (x instanceof LispDecimal32) {
            return this.number == x.getRealHalf();
        }
        if (x instanceof LispDecimal64) {
            return this.number == x.getRealHalf();
        }
        return false;
    }

    @Override
    public boolean isLessThan(LispReal x) {
        return Half.compare(this.number, x.getRealHalf()) < 0;
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        return Half.compare(this.number, x.getRealHalf()) > 0;
    }

    public BigInteger bigIntegerValue() {
        BigDecimal dec = new BigDecimal(this.number);
        return dec.toBigInteger();
    }

    @Override
    public double doubleValue() {
        return Half.toDouble(this.number);
    }

    @Override
    public int signum() {
        return this.number > 0 ? 1 : (this.number < 0 ? -1 : 0);
    }

    @Override
    public LispExactReal toExact() {
        return LispHalf.toExact(this.number);
    }

    @Override
    public String print() {
        return LispHalf.disp(Half.toDouble(this.number));
    }

    @Override
    public String getResult() {
        return LispHalf.disp(Half.toDouble(this.number));
    }

    @Override
    public boolean isInteger() {
        return LispUtils.toIntegerExact(Half.toDouble(this.number)) != null;
    }

    @Override
    public LispString toLispString(int radix) {
        double number = Half.toDouble(this.number);
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (Double.isNaN(number)) {
            return new LispString("+nan.0");
        }
        if (number == Double.POSITIVE_INFINITY) {
            return new LispString("+inf.0");
        }
        if (number == Double.NEGATIVE_INFINITY) {
            return new LispString("-inf.0");
        }
        return new LispString(Double.toString(number));
    }

    @Override
    public LispString toLispString(int radix, int precision) {
        double number = Half.toDouble(this.number);
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (precision < 0) {
            throw new IllegalArgumentException("precision must not be negative");
        }
        if (Double.isNaN(number)) {
            return new LispString("+nan.0");
        }
        if (number == Double.POSITIVE_INFINITY) {
            return new LispString("+inf.0");
        }
        if (number == Double.NEGATIVE_INFINITY) {
            return new LispString("-inf.0");
        }
        return new LispString(String.format("%" + precision + "d", number));
    }

    @Override
    public boolean isNaN() {
        return Half.isNaN(this.number);
    }

    @Override
    public boolean isOne() {
        return Half.equals(this.number, Half.parseHalf("1.0"));
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Half.isInfinite(this.number) || Half.isNaN(this.number)) {
            throw new NumberFormatException("Infinities or NaNs is not supported");
        }
        return BigDecimal.valueOf(Half.toDouble(this.number));
    }

    @Override
    public double getRealDouble() {
        return Half.toDouble(this.number);
    }

    @Override
    public long getRealDecimal64() {
        return Decimal64.toDecimal(Half.toDouble(this.number));
    }

    @Override
    public int getRealDecimal32() {
        return Decimal32.toDecimal(Half.toDouble(this.number));
    }

    @Override
    public boolean isInfinity() {
        return Half.isInfinite(this.number);
    }

    @Override
    public LispReal invert() {
        return new LispHalf(Half.div(DoubleUtils.toHalf(1.0), this.number));
    }

    @Override
    public boolean isUnit() {
        return Half.equals(this.number, Half.parseHalf("1.0"));
    }

    @Override
    public LispReal multiply(int n) {
        return new LispHalf(Half.div(DoubleUtils.toHalf(n), this.number));
    }

    @Override
    public LispReal power(int n) {
        return new LispHalf(DoubleUtils.toHalf(Math.pow(Half.toDouble(this.number), n)));
    }

    @Override
    public NumericalField<LispReal> getUniverse() {
        return FIELD;
    }

    @Override
    public int castInt() {
        return (int)Half.toDouble(this.number);
    }

    @Override
    public long castLong() {
        return (long)Half.toDouble(this.number);
    }

    @Override
    public Integer2 castInteger2() {
        return Double2.valueOf(Half.toDouble(this.number)).castInteger2();
    }

    @Override
    public int intFloor() {
        return (int)this.longFloor();
    }

    @Override
    public long longFloor() {
        return (long)Math.floor(Half.toDouble(this.number));
    }

    @Override
    public Integer2 getInteger2Floor() {
        Rational r = Rational.valueOf(Half.toDouble(this.number));
        return r.getInteger2Floor();
    }

    @Override
    public int intCeil() {
        return (int)this.longCeil();
    }

    @Override
    public long longCeil() {
        return (long)Math.ceil(Half.toDouble(this.number));
    }

    @Override
    public Integer2 getInteger2Ceil() {
        Rational r = Rational.valueOf(Half.toDouble(this.number));
        return r.getInteger2Ceil();
    }

    @Override
    public Rational getRational() {
        return LispHalf.toExact(this.number).getRational();
    }

    @Override
    public float floatValue() {
        return (float)Half.toDouble(this.number);
    }

    @Override
    public Object toObject() {
        return new Half(this.number);
    }

    @Override
    public LispReal floor() {
        return new LispHalf(DoubleUtils.toHalf(Math.floor(Half.toDouble(this.number))));
    }

    @Override
    public LispReal ceil() {
        return new LispHalf(DoubleUtils.toHalf(Math.ceil(Half.toDouble(this.number))));
    }

    @Override
    public boolean isFinite() {
        return !Half.isInfinite(this.number);
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof LispHalf) {
            return Half.compare(this.number, ((LispHalf)x).number) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.number;
    }

    @Override
    public String toString() {
        return Half.toString(this.number);
    }
}

