/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;

public final class LispComplexInfinity
extends LispComplex {
    static final LispComplexInfinity INF = new LispComplexInfinity();

    private LispComplexInfinity() {
    }

    @Override
    public LispNumber normSquared() {
        return LispDouble.POSITIVE_INFINITY;
    }

    @Override
    public LispComplex uminus() {
        return this;
    }

    @Override
    public LispComplex toExact() {
        return this;
    }

    @Override
    public LispComplex toInexact() {
        return this;
    }

    @Override
    public LispComplex conjugate() {
        return this;
    }

    @Override
    public LispReal angle() {
        return LispDouble.NaN;
    }

    @Override
    public LispReal getReal() {
        return LispDouble.NaN;
    }

    @Override
    public double getRealDouble() {
        return Double.NaN;
    }

    @Override
    public LispReal getImag() {
        return LispDouble.NaN;
    }

    @Override
    public double getImagDouble() {
        return Double.NaN;
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public LispReal norm() {
        return LispDouble.POSITIVE_INFINITY;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        return x == INF;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (!(x instanceof LispComplex)) {
            return LispDouble.NaN;
        }
        if (x == INF) {
            return LispDouble.NaN;
        }
        return this;
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (!(x instanceof LispComplex)) {
            return LispDouble.NaN;
        }
        if (x == INF) {
            return LispDouble.NaN;
        }
        return this;
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (!(x instanceof LispComplex)) {
            return LispDouble.NaN;
        }
        if (x == INF) {
            return LispDouble.NaN;
        }
        return this;
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (!(x instanceof LispComplex)) {
            return LispDouble.NaN;
        }
        if (x == INF) {
            return LispDouble.NaN;
        }
        return this;
    }

    @Override
    public LispNumber pow(int n) {
        return LispDouble.NaN;
    }

    @Override
    public LispNumber inv() {
        return LispInteger.ZERO;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public String getResult() {
        return "+inf.0@";
    }
}

