/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua.plural;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import net.morilib.lingua.plural.PluralConverter;
import net.morilib.parser.NewPropertiesParser;
import net.morilib.util.mapset.ManyToManySet;

public class SimplePluralConverter_en
implements PluralConverter {
    private Pattern _ES = Pattern.compile("^.*(s|z|sh|ch|o)$");
    private Pattern _IES = Pattern.compile("^.*[^aeiou]y$");
    private ManyToManySet<String, String> irregulars;

    SimplePluralConverter_en() {
        Class<SimplePluralConverter_en> cl = SimplePluralConverter_en.class;
        InputStream ins = null;
        NewPropertiesParser p = new NewPropertiesParser();
        try {
            ins = cl.getResourceAsStream("/" + cl.getPackage().getName().replace('.', '/') + "/simpleirregular_en.properties");
            this.irregulars = p.parse(ins);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getRegularPlural(String word) {
        if (this._ES.matcher(word).matches()) {
            return String.valueOf(word) + "es";
        }
        if (this._IES.matcher(word).matches()) {
            return String.valueOf(word.substring(0, word.length() - 1)) + "ies";
        }
        return String.valueOf(word) + "s";
    }

    @Override
    public Set<String> toPlurals(String word) {
        if (this.irregulars.containsKey(word)) {
            return this.irregulars.getValues(word);
        }
        return Collections.singleton(this.getRegularPlural(word));
    }

    @Override
    public boolean isPlural(String singular, String plural) {
        if (singular == null || plural == null) {
            throw new NullPointerException();
        }
        if (this.irregulars.containsKey(singular)) {
            return this.irregulars.contains(singular, plural);
        }
        return plural.equals(this.getRegularPlural(singular));
    }
}

