/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua.numeral;

public class LatinNumeral {
    static final String[][][] UNUS_DUO_TRES = new String[][][]{{{"\u016bnus", "\u016bna", "\u016bnum"}, {"\u016bn\u012bus", "\u016bn\u012bus", "\u016bn\u012bus"}, {"\u016bn\u012b", "\u016bn\u012b", "\u016bn\u012b"}, {"\u016bnum", "\u016bnam", "\u016bnum"}, {"\u016bn\u014d", "\u016bn\u0101", "\u016bn\u014d"}}, {{"duo", "duae", "duo"}, {"du\u014drum", "du\u0101rum", "du\u014drum"}, {"du\u014dbus", "du\u0101bus", "du\u014dbus"}, {"du\u014ds", "du\u0101s", "duo"}, {"du\u014dbus", "du\u0101bus", "du\u014dbus"}}, {{"tr\u0113s", "tr\u0113s", "tria"}, {"trium", "trium", "trium"}, {"tribus", "tribus", "tribus"}, {"tr\u0113s", "tr\u0113s", "tria"}, {"tribus", "tribus", "tribus"}}};
    static final String[] NUM_19;
    static final String DUODE = "duod\u0113";
    static final String UNDE = "\u016bnd\u0113";
    static final String DUODETRIGINTA = "duod\u0113tr\u012bgint\u0101";
    static final String UNDETRIGINTA = "\u016bnd\u0113tr\u012bgint\u0101";
    static final String[] NUM_99;
    static final String CENTUM = "centum";
    static final String[][] CENTI;
    static final String[] PREFIX_900;
    static final String MILLE = "mille";
    static final String[] MILIA;
    private static final int INIT = 1000;
    private static final int CENTI_1 = 1010;
    private static final int CENTI_99_1 = 1020;
    private static final int E_OR_MILLE = 1030;
    private static final int INIT_1000 = 1040;
    private static final int CENTI_2 = 1050;
    private static final int CENTI_99_2 = 1060;
    private static final int ACCEPT = 1070;

    static {
        String[] stringArray = new String[20];
        stringArray[4] = "quattuor";
        stringArray[5] = "qu\u012bnque";
        stringArray[6] = "sex";
        stringArray[7] = "septem";
        stringArray[8] = "oct\u014d";
        stringArray[9] = "novem";
        stringArray[10] = "decem";
        stringArray[11] = "\u016bndecem";
        stringArray[12] = "duodecem";
        stringArray[13] = "tredecem";
        stringArray[14] = "quattordecem";
        stringArray[15] = "qu\u012bndecem";
        stringArray[16] = "s\u0113decem";
        stringArray[17] = "septendecem";
        stringArray[18] = "duod\u0113v\u012bgint\u012b";
        stringArray[19] = "\u016bnd\u0113v\u012bgint\u012b";
        NUM_19 = stringArray;
        String[] stringArray2 = new String[10];
        stringArray2[2] = "v\u012bgint\u012b";
        stringArray2[3] = "tr\u012bgint\u0101";
        stringArray2[4] = "quadr\u0101gint\u0101";
        stringArray2[5] = "qu\u012bnqu\u0101gint\u0101";
        stringArray2[6] = "sex\u0101gint\u0101";
        stringArray2[7] = "septu\u0101gint\u0101";
        stringArray2[8] = "oct\u014dgint\u0101";
        stringArray2[9] = "n\u014dn\u0101gint\u0101";
        NUM_99 = stringArray2;
        CENTI = new String[][]{{"ent\u012b", "entae", "enta"}, {"ent\u014drum", "ent\u0101rum", "ent\u014drum"}, {"ent\u012bs", "ent\u012bs", "ent\u012bs"}, {"ent\u014ds", "ent\u0101s", "enta"}, {"ent\u012bs", "ent\u012bs", "ent\u012bs"}};
        String[] stringArray3 = new String[10];
        stringArray3[2] = "duc";
        stringArray3[3] = "trec";
        stringArray3[4] = "quadrig";
        stringArray3[5] = "qu\u012bng";
        stringArray3[6] = "sesc";
        stringArray3[7] = "septing";
        stringArray3[8] = "octig";
        stringArray3[9] = "n\u014dng";
        PREFIX_900 = stringArray3;
        MILIA = new String[]{"m\u012blia", "m\u012blium", "m\u012blibus", "m\u012blia", "m\u012blibus"};
    }

    static String removeMacron(String s) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0101': {
                    b.append('a');
                    break;
                }
                case '\u0113': {
                    b.append('e');
                    break;
                }
                case '\u012b': {
                    b.append('i');
                    break;
                }
                case '\u014d': {
                    b.append('o');
                    break;
                }
                case '\u016b': {
                    b.append('u');
                    break;
                }
                case '\u0100': {
                    b.append('A');
                    break;
                }
                case '\u0112': {
                    b.append('E');
                    break;
                }
                case '\u012a': {
                    b.append('I');
                    break;
                }
                case '\u014c': {
                    b.append('U');
                    break;
                }
                case '\u016a': {
                    b.append('O');
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        return b.toString();
    }

    public static String toNumeralWithMacron(int a, Gender gn, Case ce) {
        if (a >= 1000 && !gn.equals((Object)Gender.NEUTER)) {
            throw new IllegalArgumentException();
        }
        if (a <= 0) {
            throw new IllegalArgumentException();
        }
        if (a <= 3) {
            int i = a - 1;
            return UNUS_DUO_TRES[i][ce.ordinal()][gn.ordinal()];
        }
        if (a <= 19) {
            return NUM_19[a];
        }
        if (a < 100) {
            int i = a % 10;
            String is = i > 0 ? LatinNumeral.toNumeralWithMacron(i, gn, ce) : "";
            int x = a / 10;
            String xs = NUM_99[x];
            switch (i) {
                case 0: {
                    return xs;
                }
                case 8: {
                    return x < 3 ? DUODE + NUM_99[x + 1] : String.valueOf(xs) + " " + is;
                }
                case 9: {
                    return x < 3 ? UNDE + NUM_99[x + 1] : String.valueOf(xs) + " " + is;
                }
            }
            return String.valueOf(xs) + " " + is;
        }
        if (a == 100) {
            return CENTUM;
        }
        if (a < 200) {
            return "centum " + LatinNumeral.toNumeralWithMacron(a % 100, gn, ce);
        }
        if (a < 1000) {
            int c = a % 100;
            String xs = c > 0 ? " " + LatinNumeral.toNumeralWithMacron(c, gn, ce) : "";
            String cs = PREFIX_900[a / 100];
            return String.valueOf(cs) + CENTI[ce.ordinal()][gn.ordinal()] + xs;
        }
        if (a == 1000) {
            return MILLE;
        }
        if (a < 2000) {
            return "mille " + LatinNumeral.toNumeralWithMacron(a % 1000, gn, ce);
        }
        if (a < 1000000) {
            String ms = LatinNumeral.toNumeralWithMacron(a / 1000, gn, ce);
            int m = a % 1000;
            String cs = m > 0 ? " " + LatinNumeral.toNumeralWithMacron(m, gn, ce) : "";
            return String.valueOf(ms) + " " + MILIA[ce.ordinal()] + cs;
        }
        return null;
    }

    public static String toNumeral(int a, Gender gn, Case ce) {
        return LatinNumeral.removeMacron(LatinNumeral.toNumeralWithMacron(a, gn, ce));
    }

    private static boolean eqs(String a, String s, boolean mc) {
        return s != null && (mc ? s.equals(a) : s.equals(LatinNumeral.removeMacron(a)));
    }

    private static boolean eqss(String a, String s, boolean mc) {
        return s != null && (mc ? s.startsWith(a) : s.startsWith(LatinNumeral.removeMacron(a)));
    }

    private static int to3(String s, boolean mc) {
        int b = 0;
        if (s == null) {
            return -1;
        }
        int i = 0;
        while (i < UNUS_DUO_TRES.length) {
            int k = UNUS_DUO_TRES[i][0].length - 1;
            while (k >= 0) {
                int j = 0;
                while (j < UNUS_DUO_TRES[i].length) {
                    if (LatinNumeral.eqs(UNUS_DUO_TRES[i][j][k], s, mc)) {
                        b |= 1 << j;
                    }
                    ++j;
                }
                if (b > 0) {
                    return i + 1 | k << 2 | b << 4;
                }
                --k;
            }
            ++i;
        }
        return -1;
    }

    private static int to19(String s, boolean mc) {
        if (s == null) {
            return -1;
        }
        int i = 4;
        while (i < NUM_19.length) {
            if (LatinNumeral.eqs(NUM_19[i], s, mc)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int duodeundetriginta(String s, boolean mc) {
        if (LatinNumeral.eqs(DUODETRIGINTA, s, mc)) {
            return 28;
        }
        if (LatinNumeral.eqs(UNDETRIGINTA, s, mc)) {
            return 29;
        }
        return -1;
    }

    private static int to90(String s, boolean mc) {
        if (s == null) {
            return -1;
        }
        int i = 2;
        while (i < NUM_99.length) {
            if (LatinNumeral.eqs(NUM_99[i], s, mc)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int to900(String s, boolean mc) {
        int b = 0;
        if (s == null) {
            return -1;
        }
        int i = 2;
        while (i < PREFIX_900.length) {
            if (LatinNumeral.eqss(PREFIX_900[i], s, mc)) {
                String x = PREFIX_900[i];
                int k = CENTI[0].length - 1;
                while (k >= 0) {
                    int j = 0;
                    while (j < CENTI.length) {
                        if (LatinNumeral.eqs(String.valueOf(x) + CENTI[j][k], s, mc)) {
                            b |= 1 << j;
                        }
                        ++j;
                    }
                    if (b > 0) {
                        return i | k << 4 | b << 6;
                    }
                    --k;
                }
            }
            ++i;
        }
        return -1;
    }

    private static int pmilia(String s, boolean mc) {
        int b = 0;
        if (s == null) {
            return -1;
        }
        int i = 0;
        while (i < MILIA.length) {
            if (LatinNumeral.eqs(MILIA[i], s, mc)) {
                b |= 1 << i;
            }
            ++i;
        }
        return b;
    }

    private static void chkGenderCase(int ce, int gn, int c, int g) {
        if (ce >= 0 && (ce & c) == 0) {
            throw new NumberFormatException("invalid case");
        }
        if (gn >= 0 && gn != g) {
            throw new NumberFormatException("invalid gender");
        }
    }

    static int toNumber(String words, boolean mc) {
        int gn = -1;
        int ce = -1;
        int stat = 1000;
        int r = 0;
        int i = 0;
        if (words == null) {
            throw new NullPointerException();
        }
        String[] tok = words.split(" ");
        if (tok.length == 0) {
            throw new IllegalArgumentException();
        }
        block10: while (true) {
            String s = i < tok.length ? tok[i++] : null;
            switch (stat) {
                case 1000: {
                    int a = LatinNumeral.to3(s, mc);
                    if (a >= 0) {
                        r = a & 3;
                        gn = a >> 2 & 3;
                        ce = a >> 4;
                        stat = 1030;
                        continue block10;
                    }
                    a = LatinNumeral.to19(s, mc);
                    if (a > 0) {
                        r = a;
                        stat = 1030;
                        continue block10;
                    }
                    a = LatinNumeral.duodeundetriginta(s, mc);
                    if (a > 0) {
                        r = a;
                        stat = 1030;
                        continue block10;
                    }
                    a = LatinNumeral.to90(s, mc);
                    if (a > 0) {
                        r = a * 10;
                        stat = 1020;
                        continue block10;
                    }
                    if (LatinNumeral.eqs(CENTUM, s, mc)) {
                        r = 100;
                        stat = 1010;
                        continue block10;
                    }
                    a = LatinNumeral.to900(s, mc);
                    if (a >= 0) {
                        r = (a & 0xF) * 100;
                        gn = a >> 4 & 3;
                        ce = a >> 6;
                        stat = 1010;
                        continue block10;
                    }
                    if (LatinNumeral.eqs(MILLE, s, mc)) {
                        r = 1000;
                        stat = 1040;
                        continue block10;
                    }
                    throw new NumberFormatException();
                }
                case 1020: {
                    int a = LatinNumeral.to3(s, mc);
                    if (a >= 0) {
                        r += a & 3;
                        gn = a >> 2 & 3;
                        ce = a >> 4;
                        stat = 1030;
                        continue block10;
                    }
                    a = LatinNumeral.to19(s, mc);
                    if (a > 0 && a <= 9) {
                        r += a;
                        stat = 1030;
                        continue block10;
                    }
                    if (LatinNumeral.eqs(MILLE, s, mc)) {
                        r *= 1000;
                        stat = 1040;
                        continue block10;
                    }
                    a = LatinNumeral.pmilia(s, mc);
                    if (a > 0) {
                        LatinNumeral.chkGenderCase(ce, gn, a, Gender.NEUTER.ordinal());
                        r *= 1000;
                        stat = 1040;
                        continue block10;
                    }
                    if (s == null) {
                        return r;
                    }
                    throw new NumberFormatException();
                }
                case 1010: {
                    int a = LatinNumeral.to3(s, mc);
                    if (a >= 0) {
                        LatinNumeral.chkGenderCase(ce, gn, a >> 2 & 3, a >> 4);
                        r += a & 3;
                        gn = a >> 2 & 3;
                        ce = a >> 4;
                        stat = 1030;
                        continue block10;
                    }
                    a = LatinNumeral.to19(s, mc);
                    if (a > 0) {
                        r += a;
                        stat = 1030;
                        continue block10;
                    }
                    a = LatinNumeral.duodeundetriginta(s, mc);
                    if (a > 0) {
                        r += a;
                        stat = 1030;
                        continue block10;
                    }
                    a = LatinNumeral.to90(s, mc);
                    if (a > 0) {
                        r += a * 10;
                        stat = 1020;
                        continue block10;
                    }
                    if (LatinNumeral.eqs(MILLE, s, mc)) {
                        r *= 1000;
                        stat = 1040;
                        continue block10;
                    }
                    a = LatinNumeral.pmilia(s, mc);
                    if (a > 0) {
                        LatinNumeral.chkGenderCase(ce, gn, a, Gender.NEUTER.ordinal());
                        r *= 1000;
                        stat = 1040;
                        continue block10;
                    }
                    if (s == null) {
                        return r;
                    }
                    throw new NumberFormatException();
                }
                case 1030: {
                    if (LatinNumeral.eqs(MILLE, s, mc)) {
                        r = 1000;
                        stat = 1040;
                        continue block10;
                    }
                    int a = LatinNumeral.pmilia(s, mc);
                    if (a > 0) {
                        LatinNumeral.chkGenderCase(ce, gn, a, Gender.NEUTER.ordinal());
                        r *= 1000;
                        stat = 1040;
                        continue block10;
                    }
                    if (s == null) {
                        return r;
                    }
                    throw new NumberFormatException();
                }
                case 1040: {
                    int a = LatinNumeral.to3(s, mc);
                    if (a >= 0) {
                        r += a & 3;
                        gn = a >> 2 & 3;
                        ce = a >> 4;
                        stat = 1070;
                        continue block10;
                    }
                    a = LatinNumeral.to19(s, mc);
                    if (a > 0) {
                        r += a;
                        stat = 1070;
                        continue block10;
                    }
                    a = LatinNumeral.duodeundetriginta(s, mc);
                    if (a > 0) {
                        r += a;
                        stat = 1070;
                        continue block10;
                    }
                    a = LatinNumeral.to90(s, mc);
                    if (a > 0) {
                        r += a * 10;
                        stat = 1060;
                        continue block10;
                    }
                    if (LatinNumeral.eqs(CENTUM, s, mc)) {
                        r += 100;
                        stat = 1050;
                        continue block10;
                    }
                    a = LatinNumeral.to900(s, mc);
                    if (a >= 0) {
                        r += (a & 0xF) * 100;
                        gn = a >> 4 & 3;
                        ce = a >> 6;
                        stat = 1050;
                        continue block10;
                    }
                    if (s == null) {
                        return r;
                    }
                    throw new NumberFormatException();
                }
                case 1060: {
                    int a = LatinNumeral.to3(s, mc);
                    if (a >= 0) {
                        r += a & 3;
                        gn = a >> 2 & 3;
                        ce = a >> 4;
                        stat = 1070;
                        continue block10;
                    }
                    a = LatinNumeral.to19(s, mc);
                    if (a > 0 && a <= 9) {
                        r += a;
                        stat = 1070;
                        continue block10;
                    }
                    if (s == null) {
                        return r;
                    }
                    throw new NumberFormatException();
                }
                case 1050: {
                    int a = LatinNumeral.to3(s, mc);
                    if (a >= 0) {
                        LatinNumeral.chkGenderCase(ce, gn, a >> 2 & 3, a >> 4);
                        r += a & 3;
                        gn = a >> 2 & 3;
                        ce = a >> 4;
                        stat = 1070;
                        continue block10;
                    }
                    a = LatinNumeral.to19(s, mc);
                    if (a > 0) {
                        r += a;
                        stat = 1070;
                        continue block10;
                    }
                    a = LatinNumeral.duodeundetriginta(s, mc);
                    if (a > 0) {
                        r += a;
                        stat = 1070;
                        continue block10;
                    }
                    a = LatinNumeral.to90(s, mc);
                    if (a > 0) {
                        r += a * 10;
                        stat = 1060;
                        continue block10;
                    }
                    if (s == null) {
                        return r;
                    }
                    throw new NumberFormatException();
                }
                case 1070: {
                    if (s == null) {
                        return r;
                    }
                    throw new NumberFormatException();
                }
            }
            break;
        }
        throw new RuntimeException();
    }

    public static int toNumberWithMacron(String s) {
        return LatinNumeral.toNumber(s.toLowerCase(), true);
    }

    public static int toNumber(String s) {
        return LatinNumeral.toNumber(s.toLowerCase(), false);
    }

    public static enum Case {
        NOMINATIVE,
        GENITIVE,
        DATIVE,
        ACCUSATIVE,
        ABLATIVE;

    }

    public static enum Gender {
        MUSCLINE,
        FEMININE,
        NEUTER;

    }
}

