/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua;

import java.util.regex.Pattern;

public class JapaneseUtils {
    private static final int INIT = 1000;
    private static final int H_I = 1010;
    private static final int H_U = 1020;
    private static final int H_O = 1030;
    private static final int H_KI = 1040;
    private static final int H_KU = 1045;
    private static final int H_SI = 1050;
    private static final int H_TI = 1060;
    private static final int H_TU = 1070;
    private static final int H_TE = 1080;
    private static final int H_TO = 1090;
    private static final int H_NI = 1100;
    private static final int H_HI = 1110;
    private static final int H_HU = 1120;
    private static final int H_MI = 1130;
    private static final int H_RI = 1140;
    private static final int H_WA = 1150;
    private static final int H_GI = 1160;
    private static final int H_GU = 1165;
    private static final int H_ZI = 1170;
    private static final int H_DI = 1180;
    private static final int H_DE = 1190;
    private static final int H_BI = 1200;
    private static final int H_PI = 1210;
    private static final int H_VU = 1220;
    private static Pattern PTN1 = Pattern.compile(".*\\p{InHiragana}[\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7\u30c3].*");
    private static Pattern PTN2 = Pattern.compile(".*\\p{InKatakana}[\u3041\u3043\u3045\u3047\u3049\u3083\u3085\u3087\u3063].*");
    public static final int KUNREI = 1;
    public static final int DZU = 2;
    public static final int OH = 4;
    public static final int MACRON = 8;
    public static final int CIRCUMFLEX = 16;
    public static final int USE_QUOTE = 32;
    public static final int FORCE_N = 64;
    public static final int USE_HYPHEN = 128;
    private static final int K_INIT = 1000;
    private static final int K_K = 1010;
    private static final int K_S = 1020;
    private static final int K_T = 1030;
    private static final int K_N = 1040;
    private static final int K_H = 1050;
    private static final int K_M = 1060;
    private static final int K_Y = 1070;
    private static final int K_R = 1080;
    private static final int K_W = 1090;
    private static final int K_G = 1100;
    private static final int K_Z = 1110;
    private static final int K_B = 1120;
    private static final int K_D = 1130;
    private static final int K_J = 1140;
    private static final int K_C = 1150;
    private static final int K_F = 1160;
    private static final int K_L = 1170;
    private static final int K_P = 1180;
    private static final int K_Q = 1190;
    private static final int K_X = 1200;
    private static final int K_V = 1210;
    private static final int K_BY = 1220;
    private static final int K_CH = 1230;
    private static final int K_GY = 1240;
    private static final int K_GW = 1245;
    private static final int K_HY = 1250;
    private static final int K_KY = 1260;
    private static final int K_MY = 1270;
    private static final int K_NY = 1280;
    private static final int K_PY = 1290;
    private static final int K_QU = 1300;
    private static final int K_RY = 1310;
    private static final int K_SH = 1320;
    private static final int K_TS = 1330;
    private static final int K_ZY = 1340;

    private static boolean isAiueo(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
    }

    private static int rew(int i, String s) {
        int r = i;
        while (s.charAt(--r) == '\u30c3') {
        }
        return r;
    }

    public static String toRomaji(String str, int flags) {
        String s = str;
        int stat = 1000;
        if (PTN1.matcher(s).matches() || PTN2.matcher(s).matches()) {
            throw new IllegalArgumentException();
        }
        s = JapaneseUtils._katakana(s);
        boolean kun = (flags & 1) != 0;
        boolean dzu = (flags & 2) != 0;
        boolean oh = (flags & 4) != 0;
        boolean mcr = (flags & 8) != 0;
        boolean cir = (flags & 0x10) != 0 || kun;
        boolean qu1 = (flags & 0x20) != 0 || kun;
        boolean nnn = (flags & 0x40) != 0 || kun;
        boolean hyp = (flags & 0x80) != 0;
        HatsuonBuffer b = new HatsuonBuffer(oh, mcr, cir, qu1, nnn, hyp);
        int i = 0;
        while (true) {
            int c;
            int n = c = i < s.length() ? (int)s.charAt(i) : -1;
            if (c == 12483) {
                if (i == 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (i > 0 && s.charAt(i - 1) == '\u30c3' && stat == 1000) {
                    b.setHatsuon();
                }
                block0 : switch (stat) {
                    case 1000: {
                        switch (c) {
                            case 12449: 
                            case 12450: {
                                b.app("a");
                                break block0;
                            }
                            case 12452: {
                                stat = 1010;
                                break block0;
                            }
                            case 12357: 
                            case 12454: {
                                stat = 1020;
                                break block0;
                            }
                            case 12359: 
                            case 12456: {
                                b.app("e");
                                break block0;
                            }
                            case 12458: {
                                stat = 1030;
                                break block0;
                            }
                            case 12459: {
                                b.app("ka");
                                break block0;
                            }
                            case 12461: {
                                stat = 1040;
                                break block0;
                            }
                            case 12463: {
                                stat = 1045;
                                break block0;
                            }
                            case 12465: {
                                b.app("ke");
                                break block0;
                            }
                            case 12467: {
                                b.app("ko");
                                break block0;
                            }
                            case 12469: {
                                b.app("sa");
                                break block0;
                            }
                            case 12471: {
                                stat = 1050;
                                break block0;
                            }
                            case 12473: {
                                b.app("su");
                                break block0;
                            }
                            case 12475: {
                                b.app("se");
                                break block0;
                            }
                            case 12477: {
                                b.app("so");
                                break block0;
                            }
                            case 12479: {
                                b.app("ta");
                                break block0;
                            }
                            case 12481: {
                                stat = 1060;
                                break block0;
                            }
                            case 12484: {
                                stat = 1070;
                                break block0;
                            }
                            case 12486: {
                                stat = 1080;
                                break block0;
                            }
                            case 12488: {
                                stat = 1090;
                                break block0;
                            }
                            case 12490: {
                                b.app("na");
                                break block0;
                            }
                            case 12491: {
                                stat = 1100;
                                break block0;
                            }
                            case 12492: {
                                b.app("nu");
                                break block0;
                            }
                            case 12493: {
                                b.app("ne");
                                break block0;
                            }
                            case 12494: {
                                b.app("no");
                                break block0;
                            }
                            case 12495: {
                                b.app("ha");
                                break block0;
                            }
                            case 12498: {
                                stat = 1110;
                                break block0;
                            }
                            case 12501: {
                                stat = 1120;
                                break block0;
                            }
                            case 12504: {
                                b.app("he");
                                break block0;
                            }
                            case 12507: {
                                b.app("ho");
                                break block0;
                            }
                            case 12510: {
                                b.app("ma");
                                break block0;
                            }
                            case 12511: {
                                stat = 1130;
                                break block0;
                            }
                            case 12512: {
                                b.app("mu");
                                break block0;
                            }
                            case 12513: {
                                b.app("me");
                                break block0;
                            }
                            case 12514: {
                                b.app("mo");
                                break block0;
                            }
                            case 12515: 
                            case 12516: {
                                b.app("ya");
                                break block0;
                            }
                            case 12517: 
                            case 12518: {
                                b.app("yu");
                                break block0;
                            }
                            case 12519: 
                            case 12520: {
                                b.app("yo");
                                break block0;
                            }
                            case 12521: {
                                b.app("ra");
                                break block0;
                            }
                            case 12522: {
                                stat = 1140;
                                break block0;
                            }
                            case 12523: {
                                b.app("ru");
                                break block0;
                            }
                            case 12524: {
                                b.app("re");
                                break block0;
                            }
                            case 12525: {
                                b.app("ro");
                                break block0;
                            }
                            case 12527: {
                                stat = 1150;
                                break block0;
                            }
                            case 12528: {
                                b.app(kun ? "i" : "wi");
                                break block0;
                            }
                            case 12529: {
                                b.app(kun ? "e" : "we");
                                break block0;
                            }
                            case 12530: {
                                b.app(kun ? "o" : "wo");
                                break block0;
                            }
                            case 12531: {
                                b.app("n");
                                break block0;
                            }
                            case 12460: {
                                b.app("ga");
                                break block0;
                            }
                            case 12462: {
                                stat = 1160;
                                break block0;
                            }
                            case 12464: {
                                stat = 1165;
                                break block0;
                            }
                            case 12466: {
                                b.app("ge");
                                break block0;
                            }
                            case 12468: {
                                b.app("go");
                                break block0;
                            }
                            case 12470: {
                                b.app("za");
                                break block0;
                            }
                            case 12472: {
                                stat = 1170;
                                break block0;
                            }
                            case 12474: {
                                b.app("zu");
                                break block0;
                            }
                            case 12476: {
                                b.app("ze");
                                break block0;
                            }
                            case 12478: {
                                b.app("zo");
                                break block0;
                            }
                            case 12480: {
                                b.app("da");
                                break block0;
                            }
                            case 12482: {
                                stat = 1180;
                                break block0;
                            }
                            case 12485: {
                                b.app(dzu ? "dzu" : "zu");
                                break block0;
                            }
                            case 12487: {
                                stat = 1190;
                                break block0;
                            }
                            case 12489: {
                                b.app("do");
                                break block0;
                            }
                            case 12496: {
                                b.app("ba");
                                break block0;
                            }
                            case 12499: {
                                stat = 1200;
                                break block0;
                            }
                            case 12502: {
                                b.app("bu");
                                break block0;
                            }
                            case 12505: {
                                b.app("be");
                                break block0;
                            }
                            case 12508: {
                                b.app("bo");
                                break block0;
                            }
                            case 12497: {
                                b.app("pa");
                                break block0;
                            }
                            case 12500: {
                                stat = 1210;
                                break block0;
                            }
                            case 12503: {
                                b.app("pu");
                                break block0;
                            }
                            case 12506: {
                                b.app("pe");
                                break block0;
                            }
                            case 12509: {
                                b.app("po");
                                break block0;
                            }
                            case 12540: {
                                b.accentize();
                                break block0;
                            }
                            case 12451: {
                                b.app("i");
                                break block0;
                            }
                            case 12457: {
                                b.app("o");
                                break block0;
                            }
                            case 12526: {
                                b.app("wa");
                                break block0;
                            }
                            case 12532: {
                                stat = 1220;
                                break block0;
                            }
                            case 12290: {
                                b.append(".");
                                break block0;
                            }
                            case 12289: {
                                b.append(",");
                                break block0;
                            }
                            case -1: {
                                break block0;
                            }
                        }
                        b.append((char)c);
                        break;
                    }
                    case 1010: {
                        switch (c) {
                            case 12455: {
                                b.app("ye");
                                break;
                            }
                            default: {
                                b.app("i");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1020: {
                        switch (c) {
                            case 12449: {
                                b.app("wa");
                                break;
                            }
                            case 12451: {
                                b.app("wi");
                                break;
                            }
                            case 12455: {
                                b.app("we");
                                break;
                            }
                            case 12457: {
                                b.app("wo");
                                break;
                            }
                            default: {
                                if (b.charAt(b.length() - 1) != 111) {
                                    b.app("u");
                                } else {
                                    b.accentize();
                                }
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1030: {
                        switch (c) {
                            case 12458: {
                                b.app(mcr ? "\u014d" : (cir ? "\u00f4" : (oh ? "oh" : "o")));
                                break;
                            }
                            default: {
                                b.app("o");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1040: {
                        switch (c) {
                            case 12515: {
                                b.app("kya");
                                break;
                            }
                            case 12517: {
                                b.app("kyu");
                                break;
                            }
                            case 12455: {
                                b.app("kye");
                                break;
                            }
                            case 12519: {
                                b.app("kyo");
                                break;
                            }
                            default: {
                                b.app("ki");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1045: {
                        switch (c) {
                            case 12449: 
                            case 12526: {
                                b.app(kun ? "kwa" : "qua");
                                break;
                            }
                            case 12451: {
                                b.app(kun ? "kwi" : "qui");
                                break;
                            }
                            case 12455: {
                                b.app(kun ? "kwe" : "que");
                                break;
                            }
                            case 12457: {
                                b.app(kun ? "kwo" : "quo");
                                break;
                            }
                            default: {
                                b.app("ku");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1050: {
                        switch (c) {
                            case 12515: {
                                b.app(kun ? "sya" : "sha");
                                break;
                            }
                            case 12517: {
                                b.app(kun ? "syu" : "shu");
                                break;
                            }
                            case 12455: {
                                b.app(kun ? "sye" : "she");
                                break;
                            }
                            case 12519: {
                                b.app(kun ? "syo" : "sho");
                                break;
                            }
                            default: {
                                b.app(kun ? "si" : "shi");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1060: {
                        switch (c) {
                            case 12515: {
                                b.app(kun ? "tya" : "cha");
                                break;
                            }
                            case 12517: {
                                b.app(kun ? "tyu" : "chu");
                                break;
                            }
                            case 12455: {
                                b.app(kun ? "tye" : "che");
                                break;
                            }
                            case 12519: {
                                b.app(kun ? "tyo" : "cho");
                                break;
                            }
                            default: {
                                b.app(kun ? "ti" : "chi");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1070: {
                        switch (c) {
                            case 12449: {
                                b.app("tsa");
                                break;
                            }
                            case 12451: {
                                b.app("tsi");
                                break;
                            }
                            case 12455: {
                                b.app("tse");
                                break;
                            }
                            case 12457: {
                                b.app("tso");
                                break;
                            }
                            default: {
                                b.app(kun ? "tu" : "tsu");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1080: {
                        switch (c) {
                            case 12451: {
                                b.app("ti");
                                break;
                            }
                            default: {
                                b.app("te");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1090: {
                        switch (c) {
                            case 12453: {
                                b.app("tu");
                                break;
                            }
                            default: {
                                b.app("to");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1110: {
                        switch (c) {
                            case 12515: {
                                b.app("hya");
                                break;
                            }
                            case 12517: {
                                b.app("hyu");
                                break;
                            }
                            case 12455: {
                                b.app("hye");
                                break;
                            }
                            case 12519: {
                                b.app("hyo");
                                break;
                            }
                            default: {
                                b.app("hi");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1120: {
                        switch (c) {
                            case 12449: {
                                b.app("fa");
                                break;
                            }
                            case 12451: {
                                b.app("fi");
                                break;
                            }
                            case 12455: {
                                b.app("fe");
                                break;
                            }
                            case 12457: {
                                b.app("fo");
                                break;
                            }
                            default: {
                                b.app(kun ? "hu" : "fu");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1130: {
                        switch (c) {
                            case 12515: {
                                b.app("mya");
                                break;
                            }
                            case 12517: {
                                b.app("myu");
                                break;
                            }
                            case 12455: {
                                b.app("mye");
                                break;
                            }
                            case 12519: {
                                b.app("myo");
                                break;
                            }
                            default: {
                                b.app("mi");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1100: {
                        switch (c) {
                            case 12515: {
                                b.app("nya");
                                break;
                            }
                            case 12517: {
                                b.app("nyu");
                                break;
                            }
                            case 12455: {
                                b.app("nye");
                                break;
                            }
                            case 12519: {
                                b.app("nyo");
                                break;
                            }
                            default: {
                                b.app("ni");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1140: {
                        switch (c) {
                            case 12515: {
                                b.app("rya");
                                break;
                            }
                            case 12517: {
                                b.app("ryu");
                                break;
                            }
                            case 12455: {
                                b.app("rye");
                                break;
                            }
                            case 12519: {
                                b.app("ryo");
                                break;
                            }
                            default: {
                                b.app("ri");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1150: {
                        switch (c) {
                            case 12449: {
                                b.app("wa");
                                break;
                            }
                            default: {
                                b.app("wa");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1160: {
                        switch (c) {
                            case 12515: {
                                b.app("gya");
                                break;
                            }
                            case 12517: {
                                b.app("gyu");
                                break;
                            }
                            case 12455: {
                                b.app("gye");
                                break;
                            }
                            case 12519: {
                                b.app("gyo");
                                break;
                            }
                            default: {
                                b.app("gi");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1165: {
                        switch (c) {
                            case 12449: 
                            case 12526: {
                                b.app("gwa");
                                break;
                            }
                            case 12451: {
                                b.app("gwi");
                                break;
                            }
                            case 12455: {
                                b.app("gwe");
                                break;
                            }
                            case 12457: {
                                b.app("gwo");
                                break;
                            }
                            default: {
                                b.app("gu");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1170: {
                        switch (c) {
                            case 12515: {
                                b.app(kun ? "zya" : "ja");
                                break;
                            }
                            case 12517: {
                                b.app(kun ? "zyu" : "ju");
                                break;
                            }
                            case 12455: {
                                b.app(kun ? "zye" : "je");
                                break;
                            }
                            case 12519: {
                                b.app(kun ? "zyo" : "jo");
                                break;
                            }
                            default: {
                                b.app(kun ? "zi" : "ji");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1180: {
                        switch (c) {
                            case 12515: {
                                b.app(kun ? "dya" : "ja");
                                break;
                            }
                            case 12517: {
                                b.app(kun ? "dyu" : "ju");
                                break;
                            }
                            case 12455: {
                                b.app(kun ? "dye" : "je");
                                break;
                            }
                            case 12519: {
                                b.app(kun ? "dyo" : "jo");
                                break;
                            }
                            default: {
                                b.app(kun ? "zi" : "ji");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1190: {
                        switch (c) {
                            case 12451: {
                                b.app("di");
                                break;
                            }
                            default: {
                                b.app("de");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1200: {
                        switch (c) {
                            case 12515: {
                                b.app("bya");
                                break;
                            }
                            case 12517: {
                                b.app("byu");
                                break;
                            }
                            case 12455: {
                                b.app("bye");
                                break;
                            }
                            case 12519: {
                                b.app("byo");
                                break;
                            }
                            default: {
                                b.app("bi");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1210: {
                        switch (c) {
                            case 12515: {
                                b.app("pya");
                                break;
                            }
                            case 12517: {
                                b.app("pyu");
                                break;
                            }
                            case 12455: {
                                b.app("pye");
                                break;
                            }
                            case 12519: {
                                b.app("pyo");
                                break;
                            }
                            default: {
                                b.app("pi");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                        break;
                    }
                    case 1220: {
                        switch (c) {
                            case 12449: {
                                b.app("va");
                                break;
                            }
                            case 12451: {
                                b.app("vi");
                                break;
                            }
                            case 12455: {
                                b.app("ve");
                                break;
                            }
                            case 12457: {
                                b.app("vo");
                                break;
                            }
                            default: {
                                b.app("vu");
                                i = JapaneseUtils.rew(i, s);
                            }
                        }
                        stat = 1000;
                    }
                }
                if (c < 0) {
                    return b.toString();
                }
            }
            ++i;
        }
    }

    static String _katakana(String s) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.UnicodeBlock.of(c).equals(Character.UnicodeBlock.HIRAGANA)) {
                b.append((char)(c + 96));
            } else {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    public static String toKatakana(String s, boolean kun) {
        StringBuffer b = new StringBuffer();
        int stat = 1000;
        char a = '\u0000';
        char x = '\u0000';
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            block0 : switch (stat) {
                case 1000: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30a2");
                            break block0;
                        }
                        case 'b': {
                            stat = 1120;
                            break block0;
                        }
                        case 'c': {
                            stat = 1150;
                            break block0;
                        }
                        case 'd': {
                            stat = 1130;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30a8");
                            break block0;
                        }
                        case 'f': {
                            stat = 1160;
                            break block0;
                        }
                        case 'g': {
                            stat = 1100;
                            break block0;
                        }
                        case 'h': {
                            stat = 1050;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30a4");
                            break block0;
                        }
                        case 'j': {
                            stat = 1140;
                            break block0;
                        }
                        case 'k': {
                            stat = 1010;
                            break block0;
                        }
                        case 'l': {
                            stat = 1170;
                            break block0;
                        }
                        case 'm': {
                            stat = 1060;
                            break block0;
                        }
                        case 'n': {
                            stat = 1040;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30aa");
                            break block0;
                        }
                        case 'p': {
                            stat = 1180;
                            break block0;
                        }
                        case 'q': {
                            stat = 1190;
                            break block0;
                        }
                        case 'r': {
                            stat = 1080;
                            break block0;
                        }
                        case 's': {
                            stat = 1020;
                            break block0;
                        }
                        case 't': {
                            stat = 1030;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30a6");
                            break block0;
                        }
                        case 'v': {
                            stat = 1210;
                            break block0;
                        }
                        case 'w': {
                            stat = 1090;
                            break block0;
                        }
                        case 'x': {
                            stat = 1200;
                            break block0;
                        }
                        case 'y': {
                            stat = 1070;
                            break block0;
                        }
                        case 'z': {
                            stat = 1110;
                            break block0;
                        }
                        default: {
                            b.append(c);
                            break block0;
                        }
                        case '\u00e2': 
                        case '\u0101': {
                            b.append("\u30a2\u30fc");
                            break block0;
                        }
                        case '\u00ea': 
                        case '\u0113': {
                            b.append("\u30a8\u30fc");
                            break block0;
                        }
                        case '\u00ee': 
                        case '\u012b': {
                            b.append("\u30a4\u30fc");
                            break block0;
                        }
                        case '\u00f4': 
                        case '\u014d': {
                            b.append("\u30aa\u30fc");
                            break block0;
                        }
                        case '\u00fb': 
                        case '\u016b': 
                    }
                    b.append("\u30a6\u30fc");
                    break;
                }
                case 1120: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30d0");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30d9");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30d3");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30dc");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30d6");
                            stat = 1000;
                            break block0;
                        }
                        case 'b': {
                            b.append("\u30c3");
                            break block0;
                        }
                        case 'y': {
                            stat = 1220;
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1150: {
                    switch (c) {
                        case 'h': {
                            stat = 1230;
                            break block0;
                        }
                        case 'c': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1130: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30c0");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30c7");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30c7\u30a3");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30c9");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30c9\u30a5");
                            stat = 1000;
                            break block0;
                        }
                        case 'd': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1160: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30d5\u30a1");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30d5\u30a7");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30d5\u30a3");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30d5\u30a9");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30d5");
                            stat = 1000;
                            break block0;
                        }
                        case 'f': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1100: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30ac");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30b2");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30ae");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30b4");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30b0");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            stat = 1240;
                            break block0;
                        }
                        case 'w': {
                            stat = 1245;
                            break block0;
                        }
                        case 'g': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1050: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30cf");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30d8");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30d2");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30db");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30d5");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            stat = 1250;
                            break block0;
                        }
                        case 'h': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1140: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30b8\u30e3");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30b8\u30a7");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30b8");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30b8\u30e7");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30b8\u30e5");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            break block0;
                        }
                        case 'j': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1010: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30ab");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30b1");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30ad");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30b3");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30af");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            stat = 1260;
                            break block0;
                        }
                        case 'w': {
                            stat = 1300;
                            break block0;
                        }
                        case 'k': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1170: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30e9");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30ec");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30ea");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30ed");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30eb");
                            stat = 1000;
                            break block0;
                        }
                        case 'l': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1060: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30de");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30e1");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30df");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30e2");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30e0");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            stat = 1270;
                            break block0;
                        }
                        case 'm': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1040: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30ca");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30cd");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30cb");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30ce");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30cc");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            stat = 1280;
                            break block0;
                        }
                        case 'n': {
                            b.append("\u30f3");
                            break block0;
                        }
                    }
                    b.append("\u30f3");
                    --i;
                    stat = 1000;
                    break;
                }
                case 1180: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30d1");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30da");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30d4");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30dd");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30d7");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            stat = 1290;
                            break block0;
                        }
                        case 'p': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1190: {
                    switch (c) {
                        case 'u': {
                            stat = 1300;
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1080: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30e9");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30ec");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30ea");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30ed");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30eb");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            stat = 1310;
                            break block0;
                        }
                        case 'r': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1020: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30b5");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30bb");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append(kun ? "\u30b7" : "\u30b9\u30a3");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30bd");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30b9");
                            stat = 1000;
                            break block0;
                        }
                        case 'h': {
                            stat = 1320;
                            break block0;
                        }
                        case 'y': {
                            stat = 1320;
                            break block0;
                        }
                        case 's': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1030: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30bf");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30c6");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append(kun ? "\u30c1" : "\u30c6\u30a3");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30c8");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append(kun ? "\u30c4" : "\u30c8\u30a5");
                            stat = 1000;
                            break block0;
                        }
                        case 's': {
                            stat = 1330;
                            break block0;
                        }
                        case 'y': {
                            stat = 1230;
                            break block0;
                        }
                        case 't': {
                            b.append("\u30c3");
                            break block0;
                        }
                        case 'c': {
                            b.append("\u30c3");
                            stat = 1230;
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1210: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30f4\u30a1");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30f4\u30a7");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30f4\u30a3");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30f4\u30a9");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30f4");
                            stat = 1000;
                            break block0;
                        }
                        case 'v': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1090: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30ef");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30a6\u30a7");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30a6\u30a3");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30a6\u30a9");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30a6");
                            stat = 1000;
                            break block0;
                        }
                        case 'w': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1200: {
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1070: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30e4");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30a4\u30a7");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append("\u30a4");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30e8");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30e6");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1110: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30b6");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30bc");
                            stat = 1000;
                            break block0;
                        }
                        case 'i': {
                            b.append(kun ? "\u30b8" : "\u30ba\u30a3");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30be");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30ba");
                            stat = 1000;
                            break block0;
                        }
                        case 'y': {
                            stat = 1340;
                            break block0;
                        }
                        case 'z': {
                            b.append("\u30c3");
                            break block0;
                        }
                    }
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1220: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30d3\u30e3");
                            stat = 1000;
                            break block0;
                        }
                        case 'e': {
                            b.append("\u30d3\u30a7");
                            stat = 1000;
                            break block0;
                        }
                        case 'o': {
                            b.append("\u30d3\u30e7");
                            stat = 1000;
                            break block0;
                        }
                        case 'u': {
                            b.append("\u30d3\u30e5");
                            stat = 1000;
                            break block0;
                        }
                    }
                    b.append(x);
                    b.append(a);
                    b.append(c);
                    stat = 1000;
                    break;
                }
                case 1230: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30c1\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30c1\u30a7");
                            break;
                        }
                        case 'i': {
                            b.append("\u30c1");
                            break;
                        }
                        case 'o': {
                            b.append("\u30c1\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30c1\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1240: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30ae\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30ae\u30a7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30ae\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30ae\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1245: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30b0\u30a1");
                            break;
                        }
                        case 'e': {
                            b.append("\u30b0\u30a7");
                            break;
                        }
                        case 'i': {
                            b.append("\u30b0\u30a3");
                            break;
                        }
                        case 'o': {
                            b.append("\u30b0\u30a9");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1250: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30d2\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30d2\u30a7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30d2\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30d2\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1260: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30ad\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30ad\u30a7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30ad\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30ad\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1270: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30df\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30df\u30a7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30df\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30df\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1280: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30cb\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30cb\u30a7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30cb\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30cb\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1290: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30d4\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30d4\u30a7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30d4\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30d4\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1300: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30af\u30a1");
                            break;
                        }
                        case 'e': {
                            b.append("\u30af\u30a7");
                            break;
                        }
                        case 'i': {
                            b.append("\u30af\u30a3");
                            break;
                        }
                        case 'o': {
                            b.append("\u30af\u30a9");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1310: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30ea\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30ea\u30a7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30ea\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30ea\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1320: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30b7\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30b7\u30a7");
                            break;
                        }
                        case 'i': {
                            b.append("\u30b7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30b7\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30b7\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1330: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30c4\u30a1");
                            break;
                        }
                        case 'e': {
                            b.append("\u30c4\u30a7");
                            break;
                        }
                        case 'i': {
                            b.append("\u30c4\u30a3");
                            break;
                        }
                        case 'o': {
                            b.append("\u30c4\u30a9");
                            break;
                        }
                        case 'u': {
                            b.append("\u30c4");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1340: {
                    switch (c) {
                        case 'a': {
                            b.append("\u30b8\u30e3");
                            break;
                        }
                        case 'e': {
                            b.append("\u30b8\u30a7");
                            break;
                        }
                        case 'o': {
                            b.append("\u30b8\u30e7");
                            break;
                        }
                        case 'u': {
                            b.append("\u30b8\u30e5");
                            break;
                        }
                        default: {
                            b.append(x);
                            b.append(a);
                            b.append(c);
                        }
                    }
                    stat = 1000;
                }
            }
            ++i;
            x = a;
            a = c;
        }
        if (stat == 1040) {
            b.append("\u30f3");
        }
        return b.toString();
    }

    private static class HatsuonBuffer {
        private StringBuffer buf = new StringBuffer();
        private boolean hatsuon = false;
        private boolean macron = false;
        private boolean circum = false;
        private boolean oh = false;
        private boolean quote1 = false;
        private boolean nnn = false;
        private boolean hyphen = false;

        HatsuonBuffer(boolean oh, boolean macron, boolean circum, boolean quote1, boolean nnn, boolean hyphen) {
            this.oh = oh;
            this.macron = macron;
            this.circum = circum;
            this.quote1 = quote1;
            this.nnn = nnn;
            this.hyphen = hyphen;
        }

        void app(String s) {
            char c;
            char c2 = c = this.buf.length() > 0 ? this.buf.charAt(this.buf.length() - 1) : (char)'\u0000';
            if (!(this.nnn || this.buf.length() == 0 || c != 'n' || s.charAt(0) != 'b' && s.charAt(0) != 'p' && s.charAt(0) != 'm')) {
                this.buf.setCharAt(this.buf.length() - 1, 'm');
            }
            if (c == 'n' && (JapaneseUtils.isAiueo(s.charAt(0)) || s.charAt(0) == 'y')) {
                if (this.quote1) {
                    this.buf.append('\'');
                } else if (this.hyphen) {
                    this.buf.append('-');
                }
            }
            if (!this.hatsuon) {
                this.buf.append(s);
            } else {
                if (JapaneseUtils.isAiueo(s.charAt(0))) {
                    throw new IllegalArgumentException();
                }
                if (s.charAt(0) == 'c') {
                    this.buf.append('t');
                    this.buf.append(s);
                } else {
                    this.buf.append(s.charAt(0));
                    this.buf.append(s);
                }
            }
            this.hatsuon = false;
        }

        void append(String s) {
            this.buf.append(s);
        }

        void append(char c) {
            this.buf.append(c);
        }

        void setHatsuon() {
            this.hatsuon = true;
        }

        int length() {
            return this.buf.length();
        }

        int charAt(int i) {
            return this.buf.charAt(i);
        }

        void accentize() {
            int l = this.buf.length();
            if (l != 0) {
                if (this.macron) {
                    switch (this.buf.charAt(l - 1)) {
                        case 'a': {
                            this.buf.setCharAt(l - 1, '\u0101');
                            break;
                        }
                        case 'e': {
                            this.buf.setCharAt(l - 1, '\u0113');
                            break;
                        }
                        case 'i': {
                            this.buf.setCharAt(l - 1, '\u012b');
                            break;
                        }
                        case 'o': {
                            this.buf.setCharAt(l - 1, '\u014d');
                            break;
                        }
                        case 'u': {
                            this.buf.setCharAt(l - 1, '\u016b');
                        }
                    }
                } else if (this.circum) {
                    switch (this.buf.charAt(l - 1)) {
                        case 'a': {
                            this.buf.setCharAt(l - 1, '\u00e2');
                            break;
                        }
                        case 'e': {
                            this.buf.setCharAt(l - 1, '\u00ea');
                            break;
                        }
                        case 'i': {
                            this.buf.setCharAt(l - 1, '\u00ee');
                            break;
                        }
                        case 'o': {
                            this.buf.setCharAt(l - 1, '\u00f4');
                            break;
                        }
                        case 'u': {
                            this.buf.setCharAt(l - 1, '\u00fb');
                        }
                    }
                } else if (this.oh && JapaneseUtils.isAiueo(this.buf.charAt(l - 1))) {
                    this.buf.append('h');
                }
            }
        }

        public String toString() {
            return this.buf.toString();
        }
    }
}

