/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua;

public final class GreekUtils {
    private GreekUtils() {
    }

    public static String latinToGreekAlphabet(String latin) {
        StringBuilder b = new StringBuilder();
        int state = 0;
        int p = 0;
        while (true) {
            int c = p < latin.length() ? (int)latin.charAt(p) : -1;
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case 97: {
                            b.append('\u03b1');
                            break;
                        }
                        case 98: {
                            b.append('\u03b2');
                            break;
                        }
                        case 99: {
                            state = 10;
                            break;
                        }
                        case 100: {
                            b.append('\u03b4');
                            break;
                        }
                        case 101: {
                            state = 20;
                            break;
                        }
                        case 103: {
                            b.append('\u03b3');
                            break;
                        }
                        case 104: {
                            if (p == 0) break block0;
                            b.append('h');
                            break;
                        }
                        case 105: {
                            b.append('\u03b9');
                            break;
                        }
                        case 107: {
                            state = 30;
                            break;
                        }
                        case 108: {
                            b.append('\u03bb');
                            break;
                        }
                        case 109: {
                            b.append('\u03bc');
                            break;
                        }
                        case 110: {
                            state = 80;
                            break;
                        }
                        case 111: {
                            state = 40;
                            break;
                        }
                        case 112: {
                            state = 50;
                            break;
                        }
                        case 114: {
                            state = 60;
                            break;
                        }
                        case 115: {
                            b.append(p == latin.length() - 1 ? (char)'\u03c2' : '\u03c3');
                            break;
                        }
                        case 116: {
                            state = 70;
                            break;
                        }
                        case 117: {
                            b.append('\u03c5');
                            break;
                        }
                        case 120: {
                            b.append('\u03be');
                            break;
                        }
                        case 121: {
                            b.append('\u03c5');
                            break;
                        }
                        case 122: {
                            state = 90;
                            break;
                        }
                        case 65: {
                            b.append('\u0391');
                            break;
                        }
                        case 66: {
                            b.append('\u0392');
                            break;
                        }
                        case 67: {
                            state = 11;
                            break;
                        }
                        case 68: {
                            b.append('\u0394');
                            break;
                        }
                        case 69: {
                            state = 21;
                            break;
                        }
                        case 71: {
                            b.append('\u0393');
                            break;
                        }
                        case 72: {
                            if (p == 0) break block0;
                            b.append('H');
                            break;
                        }
                        case 73: {
                            b.append('\u0399');
                            break;
                        }
                        case 75: {
                            state = 31;
                            break;
                        }
                        case 76: {
                            b.append('\u039b');
                            break;
                        }
                        case 77: {
                            b.append('\u039c');
                            break;
                        }
                        case 78: {
                            state = 81;
                            break;
                        }
                        case 79: {
                            state = 41;
                            break;
                        }
                        case 80: {
                            state = 51;
                            break;
                        }
                        case 82: {
                            state = 61;
                            break;
                        }
                        case 83: {
                            b.append('\u03a3');
                            break;
                        }
                        case 84: {
                            state = 71;
                            break;
                        }
                        case 85: {
                            b.append('\u03a5');
                            break;
                        }
                        case 88: {
                            b.append('\u039e');
                            break;
                        }
                        case 89: {
                            b.append('\u03a5');
                            break;
                        }
                        case 90: {
                            state = 91;
                            break;
                        }
                        case -1: {
                            break;
                        }
                        default: {
                            b.append(c);
                            break;
                        }
                    }
                    break;
                }
                case 10: {
                    if (c == 104) {
                        b.append('\u03c7');
                    } else {
                        b.append('c');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 20: {
                    if (c == 101) {
                        b.append('\u03b7');
                    } else {
                        b.append('\u03b5');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 30: {
                    if (c == 104) {
                        b.append('\u03c7');
                    } else if (c == 115) {
                        b.append('\u03be');
                    } else {
                        b.append('\u03ba');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 40: {
                    if (c == 111) {
                        b.append('\u03c9');
                    } else {
                        b.append('\u03bf');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 50: {
                    if (c == 104) {
                        b.append('\u03c6');
                    } else if (c == 115) {
                        b.append('\u03c8');
                    } else {
                        b.append('\u03c0');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 60: {
                    b.append('\u03c1');
                    if (c != 104) {
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 70: {
                    if (c == 104) {
                        b.append('\u03b8');
                    } else {
                        b.append('\u03c4');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 80: {
                    if (c == 103) {
                        b.append("\u03b3\u03b3");
                        state = 0;
                        break;
                    }
                    if (c == 120) {
                        b.append("\u03b3\u03be");
                        state = 0;
                        break;
                    }
                    if (c == 107) {
                        state = 1000;
                        break;
                    }
                    if (c == 99) {
                        state = 1010;
                        break;
                    }
                    b.append('\u03bd');
                    --p;
                    state = 0;
                    break;
                }
                case 90: {
                    b.append('\u03b6');
                    if (c != 100) {
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 1000: {
                    if (c == 115) {
                        b.append("\u03b3\u03be");
                    } else if (c == 104) {
                        b.append("\u03b3\u03c7");
                    } else {
                        b.append("\u03bd\u03ba");
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 1010: {
                    if (c == 104) {
                        b.append("\u03b3\u03c7");
                    } else {
                        b.append("\u03bdc");
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 11: {
                    if (c == 72 || c == 104) {
                        b.append('\u03a7');
                    } else {
                        b.append('C');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 21: {
                    if (c == 69 || c == 101) {
                        b.append('\u0397');
                    } else {
                        b.append('\u0395');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 31: {
                    if (c == 72 || c == 104) {
                        b.append('\u03a7');
                    } else if (c == 83 || c == 115) {
                        b.append('\u039e');
                    } else {
                        b.append('\u039a');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 41: {
                    if (c == 79 || c == 111) {
                        b.append('\u03a9');
                    } else {
                        b.append('\u039f');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 51: {
                    if (c == 72 || c == 104) {
                        b.append('\u03a6');
                    } else if (c == 83 || c == 115) {
                        b.append('\u03a8');
                    } else {
                        b.append('\u03a0');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 61: {
                    b.append('\u03a1');
                    if (c != 72 && c != 104) {
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 71: {
                    if (c == 72 || c == 104) {
                        b.append('\u0398');
                    } else {
                        b.append('\u03a4');
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 81: {
                    if (c == 103) {
                        b.append("\u0393\u03b3");
                        state = 0;
                        break;
                    }
                    if (c == 71) {
                        b.append("\u0393\u0393");
                        state = 0;
                        break;
                    }
                    if (c == 120) {
                        b.append("\u0393\u03be");
                        state = 0;
                        break;
                    }
                    if (c == 88) {
                        b.append("\u0393\u039e");
                        state = 0;
                        break;
                    }
                    if (c == 107) {
                        state = 1001;
                        break;
                    }
                    if (c == 99) {
                        state = 1011;
                        break;
                    }
                    if (c == 75) {
                        state = 1002;
                        break;
                    }
                    if (c == 67) {
                        state = 1012;
                        break;
                    }
                    b.append('\u039d');
                    --p;
                    state = 0;
                    break;
                }
                case 91: {
                    b.append('\u0396');
                    if (c != 68 && c != 100) {
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 1001: {
                    if (c == 115) {
                        b.append("\u0393\u03be");
                    } else if (c == 104) {
                        b.append("\u0393\u03c7");
                    } else {
                        b.append("\u039d\u03ba");
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 1011: {
                    if (c == 104) {
                        b.append("\u0393\u03c7");
                    } else {
                        b.append("\u039dc");
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 1002: {
                    if (c == 83) {
                        b.append("\u0393\u039e");
                    } else if (c == 72) {
                        b.append("\u0393\u03a7");
                    } else {
                        b.append("\u039d\u039a");
                        --p;
                    }
                    state = 0;
                    break;
                }
                case 1012: {
                    if (c == 72) {
                        b.append("\u0393\u03a7");
                    } else {
                        b.append("\u039dC");
                        --p;
                    }
                    state = 0;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (c < 0) {
                return b.toString();
            }
            ++p;
        }
    }

    public static String greekToLatinAlphabet(String greek) {
        StringBuilder b = new StringBuilder();
        int c = -1;
        int q = -1;
        int p = 0;
        while (p < greek.length()) {
            q = c;
            int l = p + 1 < greek.length() ? (int)greek.charAt(p + 1) : 65;
            char c2 = greek.charAt(p);
            c = c2;
            switch (c2) {
                case '\u03b1': {
                    b.append("a");
                    break;
                }
                case '\u03b2': {
                    b.append("b");
                    break;
                }
                case '\u03b3': {
                    b.append("g");
                    break;
                }
                case '\u03b4': {
                    b.append("d");
                    break;
                }
                case '\u03b5': {
                    b.append("e");
                    break;
                }
                case '\u03b6': {
                    b.append("zd");
                    break;
                }
                case '\u03b7': {
                    b.append("ee");
                    break;
                }
                case '\u03b8': {
                    b.append("th");
                    break;
                }
                case '\u03b9': {
                    b.append("i");
                    break;
                }
                case '\u03ba': {
                    b.append("k");
                    break;
                }
                case '\u03bb': {
                    b.append("l");
                    break;
                }
                case '\u03bc': {
                    b.append("m");
                    break;
                }
                case '\u03bd': {
                    b.append("n");
                    break;
                }
                case '\u03be': {
                    b.append("ks");
                    break;
                }
                case '\u03bf': {
                    b.append("o");
                    break;
                }
                case '\u03c0': {
                    b.append("p");
                    break;
                }
                case '\u03c1': {
                    b.append(p == 0 ? "rh" : "r");
                    break;
                }
                case '\u03c3': {
                    b.append("s");
                    break;
                }
                case '\u03c2': {
                    b.append("s");
                    break;
                }
                case '\u03c4': {
                    b.append("t");
                    break;
                }
                case '\u03c5': {
                    if (q == 949 || q == 959 || q == 945 || q == 951 || q == 917 || q == 927 || q == 913 || q == 919) {
                        b.append("u");
                        break;
                    }
                    if (p == 0) {
                        b.append("hy");
                        break;
                    }
                    b.append("y");
                    break;
                }
                case '\u03c6': {
                    b.append("ph");
                    break;
                }
                case '\u03c7': {
                    b.append("ch");
                    break;
                }
                case '\u03c8': {
                    b.append("ps");
                    break;
                }
                case '\u03c9': {
                    b.append("oo");
                    break;
                }
                case '\u0391': {
                    b.append("A");
                    break;
                }
                case '\u0392': {
                    b.append("B");
                    break;
                }
                case '\u0393': {
                    b.append("G");
                    break;
                }
                case '\u0394': {
                    b.append("D");
                    break;
                }
                case '\u0395': {
                    b.append("E");
                    break;
                }
                case '\u0396': {
                    b.append("ZD");
                    break;
                }
                case '\u0397': {
                    b.append(Character.isUpperCase(l) ? "EE" : "Ee");
                    break;
                }
                case '\u0398': {
                    b.append(Character.isUpperCase(l) ? "TH" : "Th");
                    break;
                }
                case '\u0399': {
                    b.append("I");
                    break;
                }
                case '\u039a': {
                    b.append("K");
                    break;
                }
                case '\u039b': {
                    b.append("L");
                    break;
                }
                case '\u039c': {
                    b.append("M");
                    break;
                }
                case '\u039d': {
                    b.append("N");
                    break;
                }
                case '\u039e': {
                    b.append(Character.isUpperCase(l) ? "KS" : "Ks");
                    break;
                }
                case '\u039f': {
                    b.append("O");
                    break;
                }
                case '\u03a0': {
                    b.append("P");
                    break;
                }
                case '\u03a1': {
                    if (p == 0) {
                        b.append(Character.isUpperCase(l) ? "RH" : "Rh");
                        break;
                    }
                    b.append("R");
                    break;
                }
                case '\u03a3': {
                    b.append("S");
                    break;
                }
                case '\u03a4': {
                    b.append("T");
                    break;
                }
                case '\u03a5': {
                    if (q == 949 || q == 959 || q == 945 || q == 951 || q == 917 || q == 927 || q == 913 || q == 919) {
                        b.append("U");
                        break;
                    }
                    if (p == 0) {
                        b.append(Character.isUpperCase(l) ? "HY" : "Hy");
                        break;
                    }
                    b.append("Y");
                    break;
                }
                case '\u03a6': {
                    b.append(Character.isUpperCase(l) ? "PH" : "Ph");
                    break;
                }
                case '\u03a7': {
                    b.append(Character.isUpperCase(l) ? "CH" : "Ch");
                    break;
                }
                case '\u03a8': {
                    b.append(Character.isUpperCase(l) ? "PS" : "Ps");
                    break;
                }
                case '\u03a9': {
                    b.append(Character.isUpperCase(l) ? "OO" : "Oo");
                }
            }
            ++p;
        }
        return b.toString();
    }
}

