/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.proposition;

import net.morilib.lang.composite.Traverse;
import net.morilib.lang.proposition.LogicalNot;
import net.morilib.lang.proposition.Proposition;

public final class Therefore<S extends Proposition<S>>
implements Proposition<S> {
    @Traverse
    Proposition<S> assumption;
    @Traverse
    Proposition<S> conclusion;

    Therefore(Proposition<S> a, Proposition<S> c) {
        this.assumption = a;
        this.conclusion = c;
    }

    public static <S extends Proposition<S>> Proposition<S> newInstance(Proposition<S> assumption, Proposition<S> conclusion) {
        return new Therefore<S>(assumption, conclusion);
    }

    @Override
    public boolean is(Object ... variables) {
        return this.assumption.is(variables) ? this.conclusion.is(variables) : true;
    }

    @Override
    public boolean is1(Object var1) {
        return this.assumption.is(var1) ? this.conclusion.is(var1) : true;
    }

    @Override
    public boolean is2(Object var1, Object var2) {
        return this.assumption.is(var1, var2) ? this.conclusion.is(var1, var2) : true;
    }

    @Override
    public boolean isEqualTo(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (p instanceof Therefore) {
            Therefore t = (Therefore)p;
            return this.assumption.isEqualTo(t.assumption) && this.conclusion.isEqualTo(t.conclusion);
        }
        return false;
    }

    @Override
    public boolean implies(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return this.assumption.isIndependent(p) || this.assumption.implies(p) && this.conclusion.implies(p);
    }

    @Override
    public boolean isImplied(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return this.isIndependent(LogicalNot.newInstance(p));
    }

    @Override
    public boolean isIndependent(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return this.assumption.implies(p) && this.conclusion.isIndependent(p);
    }

    @Override
    public boolean isFalse() {
        return this.assumption.isTrue() && this.conclusion.isFalse();
    }

    @Override
    public boolean isTrue() {
        return this.assumption.isFalse() || this.conclusion.isTrue();
    }

    public String toString() {
        return "(" + this.assumption.toString() + " -> " + this.conclusion.toString() + ")";
    }
}

