/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar.cjkv;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.morilib.calendar.cjkv.CJKVEra;
import net.morilib.calendar.cjkv.CJKVGregorianEra;
import net.morilib.calendar.cjkv.CJKVOldEra;
import net.morilib.calendar.cjkv.MeijiEra;

public final class JapaneseEras {
    static final CJKVEra KEIO;
    public static final CJKVEra MEIJI;
    public static final CJKVEra TAISHO;
    public static final CJKVEra SHOWA;
    public static final CJKVEra HEISEI;
    static CJKVEra[] ERAS;
    static CJKVEra[] ANCIENT_ERAS;
    public static final List<CJKVEra> SUPPORTED_ERAS;
    public static final List<CJKVEra> SUPPORTED_ANCIENT_ERAS;

    static {
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[]{5, 4694};
        int[] nArray = new int[2];
        nArray[1] = 314;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 373;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{4, 4825};
        KEIO = new CJKVOldEra("\u6176\u5fdc", "1865/01/27", "1865/05/01", "1868/10/23", (int[][])nArrayArray);
        MEIJI = new MeijiEra();
        TAISHO = new CJKVGregorianEra("\u5927\u6b63", "T", "1912/01/01", "1912/07/30", "1926/12/24");
        SHOWA = new CJKVGregorianEra("\u662d\u548c", "S", "1926/01/01", "1926/12/25", "1989/01/07");
        HEISEI = new CJKVGregorianEra("\u5e73\u6210", "H", "1989/01/01", "1989/01/07", null);
        ERAS = new CJKVEra[]{HEISEI, SHOWA, TAISHO, MEIJI};
        ANCIENT_ERAS = new CJKVEra[]{KEIO};
        SUPPORTED_ERAS = Collections.unmodifiableList(Arrays.asList(ERAS));
        SUPPORTED_ANCIENT_ERAS = Collections.unmodifiableList(Arrays.asList(ANCIENT_ERAS));
    }

    private JapaneseEras() {
    }

    public static CJKVEra getEra(Date d) {
        int i = 0;
        while (i < ERAS.length) {
            if (ERAS[i].isEra(d)) {
                return ERAS[i];
            }
            ++i;
        }
        return null;
    }

    public static CJKVEra getEraFromDescription(String e) {
        int i = 0;
        while (i < ERAS.length) {
            if (ERAS[i].toString().equals(e)) {
                return ERAS[i];
            }
            ++i;
        }
        return null;
    }

    public static CJKVEra getEraFromShortDescription(String e) {
        int i = 0;
        while (i < ERAS.length) {
            if (ERAS[i].getShortDescription().equals(e)) {
                return ERAS[i];
            }
            ++i;
        }
        return null;
    }

    public static CJKVEra getEraFromInitialLetter(String e) {
        int i = 0;
        while (i < ERAS.length) {
            if (ERAS[i].getInitialLetter().equals(e)) {
                return ERAS[i];
            }
            ++i;
        }
        return null;
    }

    public static CJKVEra getAncientEra(Date d) {
        if (MEIJI.before(d)) {
            return JapaneseEras.getEra(d);
        }
        int i = 0;
        while (i < ANCIENT_ERAS.length) {
            if (ANCIENT_ERAS[i].isEra(d)) {
                return ANCIENT_ERAS[i];
            }
            ++i;
        }
        return null;
    }
}

