/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFA;
import net.morilib.automata.nfa.NFAEdges;
import net.morilib.automata.nfa.NFAState;
import net.morilib.automata.nfa.RangeTree;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public abstract class NFAObject<T, A, B>
implements NFA<T, A, B> {
    NFAObject() {
    }

    abstract void addStates(Set<NFAState> var1, NFAState var2, T var3);

    abstract void addStates(Set<NFAState> var1, NFAState var2, Range var3);

    abstract void addStatesBound(Set<NFAState> var1, NFAState var2, EnumSet<TextBound> var3);

    abstract void addInitialStates(Set<NFAState> var1);

    abstract void addStatesEpsilon(Set<NFAState> var1, NFAState var2);

    @Override
    public Set<NFAState> getInitialStates() {
        HashSet<NFAState> res = new HashSet<NFAState>();
        this.addInitialStates(res);
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, T alphabet) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        this.addStates(res, state, alphabet);
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        this.addStates((Set<NFAState>)res, state, rng);
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> b) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        this.addStatesBound(res, state, b);
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        this.addStatesEpsilon(res, state);
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> b) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        this.addStatesBound(res, state, b);
        return Collections.unmodifiableSet(res);
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        for (NFAState s : states) {
            if (!this.isFinal(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NFAEdges<T> getEdges(NFAState state) {
        return new Edges(state);
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        Iterable rt = null;
        for (NFAState s : states) {
            for (Interval i : this.nextAlphabets(s)) {
                if (rt == null) {
                    rt = new RangeTree(i);
                    continue;
                }
                ((RangeTree)rt).insert(i);
            }
        }
        return rt == null ? new HashSet() : rt;
    }

    class Edges
    implements NFAEdges<T> {
        NFAState state;

        Edges(NFAState state) {
            this.state = state;
        }

        @Override
        public Set<NFAState> goNext(T alphabet) {
            HashSet<NFAState> res = new HashSet<NFAState>();
            NFAObject.this.addStates(res, this.state, alphabet);
            return res;
        }

        @Override
        public Set<NFAState> goNextEpsilon() {
            HashSet<NFAState> res = new HashSet<NFAState>();
            NFAObject.this.addStatesEpsilon(res, this.state);
            return res;
        }

        @Override
        public Set<? extends Range> nextAlphabets() {
            return NFAObject.this.nextAlphabets(this.state);
        }

        @Override
        public boolean isNextEpsilon() {
            return this.isNextEpsilon();
        }
    }

    static final class IntStateObject
    implements NFAState {
        private Object fa;
        private int internal;

        public IntStateObject(Object fa, int internal) {
            this.fa = fa;
            this.internal = internal;
        }

        public boolean equals(Object o) {
            if (o instanceof IntStateObject) {
                IntStateObject n = (IntStateObject)o;
                return this.fa.equals(n.fa) && n.internal == this.internal;
            }
            return false;
        }

        public int hashCode() {
            return this.fa.hashCode() << 8 | this.internal & 0xFF;
        }

        public String toString() {
            return String.valueOf(this.fa.toString()) + ":" + Integer.toString(this.internal);
        }
    }
}

