/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.arith;

public class Signum3
implements Comparable<Signum3> {
    public static final Signum3 POSITIVE = new Signum3(1);
    public static final Signum3 NEGATIVE = new Signum3(-1);
    public static final Signum3 ZERO = new Signum3(0);
    private int signum;

    private Signum3(int signum) {
        this.signum = signum;
    }

    public static Signum3 toSignum(int x) {
        return x > 0 ? POSITIVE : (x < 0 ? NEGATIVE : ZERO);
    }

    public static Signum3 toSignum(long x) {
        return x > 0L ? POSITIVE : (x < 0L ? NEGATIVE : ZERO);
    }

    public Signum3 multiply(Signum3 x) {
        if (this.signum == 0 || x.signum == 0) {
            return ZERO;
        }
        if (this.signum > 0 ^ x.signum > 0) {
            return NEGATIVE;
        }
        return POSITIVE;
    }

    public int signum() {
        return this.signum;
    }

    public Signum3 negate() {
        switch (this.signum) {
            case 1: {
                return NEGATIVE;
            }
            case 0: {
                return ZERO;
            }
            case -1: {
                return POSITIVE;
            }
        }
        throw new RuntimeException();
    }

    public int multiply(int x) {
        switch (this.signum) {
            case 1: {
                return x;
            }
            case 0: {
                return 0;
            }
            case -1: {
                return -x;
            }
        }
        throw new RuntimeException();
    }

    public double multiply(double x) {
        switch (this.signum) {
            case 1: {
                return x;
            }
            case 0: {
                return 0.0;
            }
            case -1: {
                return -x;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public int compareTo(Signum3 o) {
        return this.signum < o.signum ? -1 : (this.signum > o.signum ? 1 : 0);
    }

    public String toString() {
        return this.signum > 0 ? "+" : (this.signum < 0 ? "-" : "0");
    }
}

