/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.arith;

import net.morilib.arith.NonnegativeDegree;

public class AngleDegree
extends Number {
    private int MAX360 = 129600000;
    private static NonnegativeDegree DEGREE360 = new NonnegativeDegree(360, 0, 0, 0);
    private NonnegativeDegree degree;

    AngleDegree(int x) {
        this.degree = new NonnegativeDegree(x);
    }

    AngleDegree(NonnegativeDegree degree) {
        this.degree = degree;
    }

    public AngleDegree(int degree, int minutes, int seconds, int undersec) {
        this.degree = degree > 0 ? new NonnegativeDegree(degree % 360, minutes, seconds, undersec) : (degree < 0 ? DEGREE360.subtract(new NonnegativeDegree(-(degree % 360), minutes, seconds, undersec)) : (minutes > 0 ? new NonnegativeDegree(0, minutes, seconds, undersec) : (minutes < 0 ? DEGREE360.subtract(new NonnegativeDegree(0, -minutes, seconds, undersec)) : (seconds > 0 ? new NonnegativeDegree(0, 0, seconds, undersec) : (seconds < 0 ? DEGREE360.subtract(new NonnegativeDegree(0, 0, -seconds, undersec)) : (undersec > 0 ? new NonnegativeDegree(0, 0, 0, undersec) : (undersec < 0 ? DEGREE360.subtract(new NonnegativeDegree(0, 0, 0, -undersec)) : NonnegativeDegree.ZERO)))))));
    }

    public static AngleDegree parse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new NumberFormatException();
        }
        switch (string.charAt(0)) {
            case '+': {
                NonnegativeDegree d = NonnegativeDegree.parse(string.substring(1));
                return new AngleDegree(d.remainder(DEGREE360));
            }
            case '-': {
                NonnegativeDegree d = NonnegativeDegree.parse(string.substring(1));
                return new AngleDegree(DEGREE360.subtract(d.remainder(DEGREE360)));
            }
        }
        NonnegativeDegree d = NonnegativeDegree.parse(string);
        return new AngleDegree(d.remainder(DEGREE360));
    }

    public AngleDegree add(AngleDegree x) {
        return new AngleDegree(this.degree.add(x.degree).remainder(DEGREE360));
    }

    public AngleDegree subtract(AngleDegree x) {
        if (this.degree.compareTo(x.degree) >= 0) {
            return new AngleDegree(this.degree.subtract(x.degree));
        }
        return new AngleDegree(DEGREE360.subtract(x.degree.subtract(this.degree)));
    }

    public AngleDegree multiply(int x) {
        int c = this.degree.toCentiSecond();
        long a = x < 0 ? this.MAX360 - c : c;
        a = a * (long)Math.abs(x) % (long)this.MAX360;
        return new AngleDegree(new NonnegativeDegree((int)a));
    }

    public AngleDegree multiply(double x) {
        double r = this.degree.doubleValue() * x;
        r = (r = Math.IEEEremainder(r, 1296000.0)) < 0.0 ? 1296000.0 + r : r;
        return new AngleDegree(new NonnegativeDegree(r));
    }

    public AngleDegree divide(int x) {
        long a = this.degree.toCentiSecond() / Math.abs(x) % this.MAX360;
        a = x < 0 ? (long)this.MAX360 - a : a;
        return new AngleDegree(new NonnegativeDegree((int)a));
    }

    public AngleDegree divide(double x) {
        double r = this.degree.doubleValue() / x;
        r = (r = Math.IEEEremainder(r, 1296000.0)) < 0.0 ? 1296000.0 + r : r;
        return new AngleDegree(new NonnegativeDegree(r));
    }

    @Override
    public int intValue() {
        return this.degree.intValue();
    }

    @Override
    public long longValue() {
        return this.degree.longValue();
    }

    @Override
    public float floatValue() {
        return this.degree.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.degree.doubleValue();
    }

    public int hashCode() {
        return this.degree.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AngleDegree) {
            return this.degree.equals(((AngleDegree)o).degree);
        }
        return false;
    }

    public String toString() {
        return this.degree.toString();
    }
}

