/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.locale;

import java.util.Locale;

import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.NoArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/04/21
 */
public class AvailableLocales extends NoArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.NoArgs#execute(net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Environment env, LispMessage mesg) {
		Locale[] ls = Locale.getAvailableLocales();
		ConsListBuilder b = new ConsListBuilder();

		for(Locale l : ls) {
			b.append(new LispLocale(l));
		}
		return b.get();
	}

}
