/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractCharacterCollection;
import net.morilib.util.primitive.AbstractFloatSet;
import net.morilib.util.primitive.CharacterCollection;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.map.op.CharacterValueMap;
import net.morilib.util.primitive.map.po.FloatMap;
import net.morilib.util.primitive.map.pp.FloatCharacterMap;

public abstract class AbstractFloatCharacterMap
implements FloatCharacterMap {
    private transient FloatSet keySet = null;
    private transient CharacterCollection values = null;
    private transient Set<FloatMap.PrimitiveEntryK<Character>> entrySetK = null;
    private transient Set<CharacterValueMap.PrimitiveEntryV<Float>> entrySetV = null;
    private transient Set<Map.Entry<Float, Character>> entrySet = null;

    @Override
    public void clear() {
        Iterator<FloatCharacterMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(char v) {
        for (FloatCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public char f(float k) {
        for (FloatCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Character getElement(float k) {
        return Character.valueOf(this.f(k));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet floatKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(FloatCharacterMap map) {
        for (FloatCharacterMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Character) {
            return this.containsKeyElement(((Float)key).floatValue());
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        if (key instanceof Character) {
            return this.getElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public Character put(Float key, char value) {
        return this.putElement(key.floatValue(), value);
    }

    @Override
    public Character remove(Object key) {
        if (key instanceof Character) {
            return this.removeElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Character> m) {
        for (Map.Entry<? extends Float, ? extends Character> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatSet keySet() {
        return this.floatKeySet();
    }

    @Override
    public Set<Map.Entry<Float, Character>> entrySet() {
        final Set<FloatCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Float, Character>>(){

                @Override
                public Iterator<Map.Entry<Float, Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Float, Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Float, Character> next() {
                            final FloatCharacterMap.PrimitiveEntry o = (FloatCharacterMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Float, Character>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public Character getValue() {
                                    return Character.valueOf(o.getValue());
                                }

                                @Override
                                public Character setValue(Character value) {
                                    return Character.valueOf(o.setValue(value.charValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(float k) {
        for (FloatCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Character get(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.getElement((char)k);
    }

    @Override
    public Character put(int k, Character v) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.putElement((float)k, v);
    }

    @Override
    public Character removeElement(float k) {
        Iterator<FloatCharacterMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            FloatCharacterMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            char r = e.getValue();
            i.remove();
            return Character.valueOf(r);
        }
        return null;
    }

    @Override
    public Character remove(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<FloatMap.PrimitiveEntryK<Character>> floatKeyEntrySet() {
        final Set<FloatCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<FloatMap.PrimitiveEntryK<Character>>(){

                @Override
                public Iterator<FloatMap.PrimitiveEntryK<Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatMap.PrimitiveEntryK<Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatMap.PrimitiveEntryK<Character> next() {
                            final FloatCharacterMap.PrimitiveEntry o = (FloatCharacterMap.PrimitiveEntry)i.next();
                            return new FloatMap.PrimitiveEntryK<Character>(){

                                @Override
                                public float getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Character getValue() {
                                    return Character.valueOf(o.getValue());
                                }

                                @Override
                                public Character setValue(Character value) {
                                    return Character.valueOf(o.setValue(value.charValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Character putElement(float k, Character v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatMap<Character> map) {
        for (FloatMap.PrimitiveEntryK<Character> e : map.floatKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((char)v);
    }

    @Override
    public Set<CharacterValueMap.PrimitiveEntryV<Float>> charValueEntrySet() {
        final Set<FloatCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<CharacterValueMap.PrimitiveEntryV<Float>>(){

                @Override
                public Iterator<CharacterValueMap.PrimitiveEntryV<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<CharacterValueMap.PrimitiveEntryV<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public CharacterValueMap.PrimitiveEntryV<Float> next() {
                            final FloatCharacterMap.PrimitiveEntry o = (FloatCharacterMap.PrimitiveEntry)i.next();
                            return new CharacterValueMap.PrimitiveEntryV<Float>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public char getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public char setValue(char value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public char getElement(Object k) {
        if (k instanceof Float) {
            return this.f(((Float)k).floatValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public char putElement(Float k, char v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(CharacterValueMap<Float> map) {
        for (CharacterValueMap.PrimitiveEntryV<Float> e : map.charValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterCollection charValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Character) {
            return this.containsValueElement(((Character)value).charValue());
        }
        return false;
    }

    @Override
    public Character put(Float key, Character value) {
        return this.putElement(key.floatValue(), value.charValue());
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (FloatCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof FloatCharacterMap)) break block1;
            m = (FloatCharacterMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey()).charValue();
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (FloatCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractFloatSet {
        private Set<FloatCharacterMap.PrimitiveEntry> eset;

        private KSet(Set<FloatCharacterMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<FloatCharacterMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public float next() {
                    return ((FloatCharacterMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatCharacterMap.this.size();
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractFloatCharacterMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatCharacterMap.this.clear();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractCharacterCollection {
        private Set<FloatCharacterMap.PrimitiveEntry> eset;

        private VCol(Set<FloatCharacterMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public CharacterIterator charIterator() {
            final Iterator<FloatCharacterMap.PrimitiveEntry> ei = this.eset.iterator();
            return new CharacterIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public char next() {
                    return ((FloatCharacterMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatCharacterMap.this.size();
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsChar(char o) {
            return AbstractFloatCharacterMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatCharacterMap.this.clear();
        }
    }
}

