/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.AbstractDoubleCollection;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.DoubleCollection;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.map.op.DoubleValueMap;
import net.morilib.util.primitive.map.po.ByteMap;
import net.morilib.util.primitive.map.pp.ByteDoubleMap;

public abstract class AbstractByteDoubleMap
implements ByteDoubleMap {
    private transient ByteSet keySet = null;
    private transient DoubleCollection values = null;
    private transient Set<ByteMap.PrimitiveEntryK<Double>> entrySetK = null;
    private transient Set<DoubleValueMap.PrimitiveEntryV<Byte>> entrySetV = null;
    private transient Set<Map.Entry<Byte, Double>> entrySet = null;

    @Override
    public void clear() {
        Iterator<ByteDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(double v) {
        for (ByteDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public double f(byte k) {
        for (ByteDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Double getElement(byte k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet byteKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(ByteDoubleMap map) {
        for (ByteDoubleMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Double) {
            return this.containsKeyElement((Byte)key);
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        if (key instanceof Double) {
            return this.getElement((Byte)key);
        }
        return null;
    }

    @Override
    public Double put(Byte key, double value) {
        return this.putElement((byte)key, value);
    }

    @Override
    public Double remove(Object key) {
        if (key instanceof Double) {
            return this.removeElement((Byte)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Double> m) {
        for (Map.Entry<? extends Byte, ? extends Double> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteSet keySet() {
        return this.byteKeySet();
    }

    @Override
    public Set<Map.Entry<Byte, Double>> entrySet() {
        final Set<ByteDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Byte, Double>>(){

                @Override
                public Iterator<Map.Entry<Byte, Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Byte, Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Byte, Double> next() {
                            final ByteDoubleMap.PrimitiveEntry o = (ByteDoubleMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Byte, Double>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((byte)k);
    }

    @Override
    public boolean containsKeyElement(byte k) {
        for (ByteDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Double get(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Double put(int k, Double v) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((byte)k, v);
    }

    @Override
    public Double removeElement(byte k) {
        Iterator<ByteDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            ByteDoubleMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            double r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Double remove(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((byte)k);
    }

    @Override
    public Set<ByteMap.PrimitiveEntryK<Double>> byteKeyEntrySet() {
        final Set<ByteDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<ByteMap.PrimitiveEntryK<Double>>(){

                @Override
                public Iterator<ByteMap.PrimitiveEntryK<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteMap.PrimitiveEntryK<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteMap.PrimitiveEntryK<Double> next() {
                            final ByteDoubleMap.PrimitiveEntry o = (ByteDoubleMap.PrimitiveEntry)i.next();
                            return new ByteMap.PrimitiveEntryK<Double>(){

                                @Override
                                public byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Double putElement(byte k, Double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteMap<Double> map) {
        for (ByteMap.PrimitiveEntryK<Double> e : map.byteKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<DoubleValueMap.PrimitiveEntryV<Byte>> doubleValueEntrySet() {
        final Set<ByteDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<DoubleValueMap.PrimitiveEntryV<Byte>>(){

                @Override
                public Iterator<DoubleValueMap.PrimitiveEntryV<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleValueMap.PrimitiveEntryV<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleValueMap.PrimitiveEntryV<Byte> next() {
                            final ByteDoubleMap.PrimitiveEntry o = (ByteDoubleMap.PrimitiveEntry)i.next();
                            return new DoubleValueMap.PrimitiveEntryV<Byte>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public double setValue(double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public double getElement(Object k) {
        if (k instanceof Byte) {
            return this.f((Byte)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double putElement(Byte k, double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleValueMap<Byte> map) {
        for (DoubleValueMap.PrimitiveEntryV<Byte> e : map.doubleValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection doubleValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Double) {
            return this.containsValueElement((Double)value);
        }
        return false;
    }

    @Override
    public Double put(Byte key, Double value) {
        return this.putElement((byte)key, (double)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ByteDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ByteDoubleMap)) break block1;
            m = (ByteDoubleMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ByteDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractByteSet {
        private Set<ByteDoubleMap.PrimitiveEntry> eset;

        private KSet(Set<ByteDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<ByteDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public byte next() {
                    return ((ByteDoubleMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteDoubleMap.this.size();
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractByteDoubleMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteDoubleMap.this.clear();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractDoubleCollection {
        private Set<ByteDoubleMap.PrimitiveEntry> eset;

        private VCol(Set<ByteDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<ByteDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public double next() {
                    return ((ByteDoubleMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteDoubleMap.this.size();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractByteDoubleMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteDoubleMap.this.clear();
        }
    }
}

